/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.Particle;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.BuiltinSound;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.CustomSound;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;
import org.jetbrains.annotations.Nullable;

public class ClientboundExplodePacket
implements MinecraftPacket {
    private final Vector3d center;
    @Nullable
    private final Vector3d playerKnockback;
    @lombok.NonNull
    private final Particle explosionParticle;
    @lombok.NonNull
    private final Sound explosionSound;

    public ClientboundExplodePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.center = Vector3d.from((double)in.readDouble(), (double)in.readDouble(), (double)in.readDouble());
        this.playerKnockback = helper.readNullable(in, input -> Vector3d.from((double)input.readDouble(), (double)input.readDouble(), (double)input.readDouble()));
        this.explosionParticle = helper.readParticle(in);
        this.explosionSound = helper.readById(in, BuiltinSound::from, helper::readSoundEvent);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeDouble(this.center.getX());
        out.writeDouble(this.center.getY());
        out.writeDouble(this.center.getZ());
        helper.writeNullable(out, this.playerKnockback, (output, playerKnockback) -> {
            output.writeDouble(playerKnockback.getX());
            output.writeDouble(playerKnockback.getY());
            output.writeDouble(playerKnockback.getZ());
        });
        helper.writeParticle(out, this.explosionParticle);
        if (this.explosionSound instanceof CustomSound) {
            helper.writeVarInt(out, 0);
            helper.writeSoundEvent(out, this.explosionSound);
        } else {
            helper.writeVarInt(out, ((BuiltinSound)this.explosionSound).ordinal() + 1);
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Vector3d getCenter() {
        return this.center;
    }

    @Nullable
    public Vector3d getPlayerKnockback() {
        return this.playerKnockback;
    }

    @lombok.NonNull
    public Particle getExplosionParticle() {
        return this.explosionParticle;
    }

    @lombok.NonNull
    public Sound getExplosionSound() {
        return this.explosionSound;
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundExplodePacket)) {
            return false;
        }
        ClientboundExplodePacket other = (ClientboundExplodePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vector3d this$center = this.getCenter();
        Vector3d other$center = other.getCenter();
        if (this$center == null ? other$center != null : !this$center.equals(other$center)) {
            return false;
        }
        Vector3d this$playerKnockback = this.getPlayerKnockback();
        Vector3d other$playerKnockback = other.getPlayerKnockback();
        if (this$playerKnockback == null ? other$playerKnockback != null : !this$playerKnockback.equals(other$playerKnockback)) {
            return false;
        }
        Particle this$explosionParticle = this.getExplosionParticle();
        Particle other$explosionParticle = other.getExplosionParticle();
        if (this$explosionParticle == null ? other$explosionParticle != null : !((Object)this$explosionParticle).equals(other$explosionParticle)) {
            return false;
        }
        Sound this$explosionSound = this.getExplosionSound();
        Sound other$explosionSound = other.getExplosionSound();
        return !(this$explosionSound == null ? other$explosionSound != null : !this$explosionSound.equals(other$explosionSound));
    }

    protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
        return other instanceof ClientboundExplodePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3d $center = this.getCenter();
        result = result * 59 + ($center == null ? 43 : $center.hashCode());
        Vector3d $playerKnockback = this.getPlayerKnockback();
        result = result * 59 + ($playerKnockback == null ? 43 : $playerKnockback.hashCode());
        Particle $explosionParticle = this.getExplosionParticle();
        result = result * 59 + ($explosionParticle == null ? 43 : ((Object)$explosionParticle).hashCode());
        Sound $explosionSound = this.getExplosionSound();
        result = result * 59 + ($explosionSound == null ? 43 : $explosionSound.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundExplodePacket(center=" + this.getCenter() + ", playerKnockback=" + this.getPlayerKnockback() + ", explosionParticle=" + this.getExplosionParticle() + ", explosionSound=" + this.getExplosionSound() + ")";
    }

    public @NonNull ClientboundExplodePacket withCenter(Vector3d center) {
        return this.center == center ? this : new ClientboundExplodePacket(center, this.playerKnockback, this.explosionParticle, this.explosionSound);
    }

    public @NonNull ClientboundExplodePacket withPlayerKnockback(@Nullable Vector3d playerKnockback) {
        return this.playerKnockback == playerKnockback ? this : new ClientboundExplodePacket(this.center, playerKnockback, this.explosionParticle, this.explosionSound);
    }

    public @NonNull ClientboundExplodePacket withExplosionParticle(@lombok.NonNull Particle explosionParticle) {
        if (explosionParticle == null) {
            throw new NullPointerException("explosionParticle is marked non-null but is null");
        }
        return this.explosionParticle == explosionParticle ? this : new ClientboundExplodePacket(this.center, this.playerKnockback, explosionParticle, this.explosionSound);
    }

    public @NonNull ClientboundExplodePacket withExplosionSound(@lombok.NonNull Sound explosionSound) {
        if (explosionSound == null) {
            throw new NullPointerException("explosionSound is marked non-null but is null");
        }
        return this.explosionSound == explosionSound ? this : new ClientboundExplodePacket(this.center, this.playerKnockback, this.explosionParticle, explosionSound);
    }

    public ClientboundExplodePacket(Vector3d center, @Nullable Vector3d playerKnockback, @lombok.NonNull Particle explosionParticle, @lombok.NonNull Sound explosionSound) {
        if (explosionParticle == null) {
            throw new NullPointerException("explosionParticle is marked non-null but is null");
        }
        if (explosionSound == null) {
            throw new NullPointerException("explosionSound is marked non-null but is null");
        }
        this.center = center;
        this.playerKnockback = playerKnockback;
        this.explosionParticle = explosionParticle;
        this.explosionSound = explosionSound;
    }
}

