/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class ClientboundOpenBookPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Hand hand;

    public ClientboundOpenBookPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.hand = Hand.from(helper.readVarInt(in));
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.hand.ordinal());
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Hand getHand() {
        return this.hand;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundOpenBookPacket)) {
            return false;
        }
        ClientboundOpenBookPacket other = (ClientboundOpenBookPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hand this$hand = this.getHand();
        Hand other$hand = other.getHand();
        return !(this$hand == null ? other$hand != null : !((Object)((Object)this$hand)).equals((Object)other$hand));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundOpenBookPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hand $hand = this.getHand();
        result = result * 59 + ($hand == null ? 43 : ((Object)((Object)$hand)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundOpenBookPacket(hand=" + this.getHand() + ")";
    }

    public @NonNull ClientboundOpenBookPacket withHand(@lombok.NonNull Hand hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        return this.hand == hand ? this : new ClientboundOpenBookPacket(hand);
    }

    public ClientboundOpenBookPacket(@lombok.NonNull Hand hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        this.hand = hand;
    }
}

