/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundEntityPositionSyncPacket
implements MinecraftPacket {
    private final int id;
    private final Vector3d position;
    private final Vector3d deltaMovement;
    private final float yRot;
    private final float xRot;
    private final boolean onGround;

    public ClientboundEntityPositionSyncPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.id = helper.readVarInt(in);
        this.position = Vector3d.from((double)in.readDouble(), (double)in.readDouble(), (double)in.readDouble());
        this.deltaMovement = Vector3d.from((double)in.readDouble(), (double)in.readDouble(), (double)in.readDouble());
        this.yRot = in.readFloat();
        this.xRot = in.readFloat();
        this.onGround = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.id);
        out.writeDouble(this.position.getX());
        out.writeDouble(this.position.getY());
        out.writeDouble(this.position.getZ());
        out.writeDouble(this.deltaMovement.getX());
        out.writeDouble(this.deltaMovement.getY());
        out.writeDouble(this.deltaMovement.getZ());
        out.writeFloat(this.yRot);
        out.writeFloat(this.xRot);
        out.writeBoolean(this.onGround);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getId() {
        return this.id;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public Vector3d getDeltaMovement() {
        return this.deltaMovement;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundEntityPositionSyncPacket)) {
            return false;
        }
        ClientboundEntityPositionSyncPacket other = (ClientboundEntityPositionSyncPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (Float.compare(this.getYRot(), other.getYRot()) != 0) {
            return false;
        }
        if (Float.compare(this.getXRot(), other.getXRot()) != 0) {
            return false;
        }
        if (this.isOnGround() != other.isOnGround()) {
            return false;
        }
        Vector3d this$position = this.getPosition();
        Vector3d other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Vector3d this$deltaMovement = this.getDeltaMovement();
        Vector3d other$deltaMovement = other.getDeltaMovement();
        return !(this$deltaMovement == null ? other$deltaMovement != null : !this$deltaMovement.equals(other$deltaMovement));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundEntityPositionSyncPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + Float.floatToIntBits(this.getYRot());
        result = result * 59 + Float.floatToIntBits(this.getXRot());
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        Vector3d $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Vector3d $deltaMovement = this.getDeltaMovement();
        result = result * 59 + ($deltaMovement == null ? 43 : $deltaMovement.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundEntityPositionSyncPacket(id=" + this.getId() + ", position=" + this.getPosition() + ", deltaMovement=" + this.getDeltaMovement() + ", yRot=" + this.getYRot() + ", xRot=" + this.getXRot() + ", onGround=" + this.isOnGround() + ")";
    }

    public @NonNull ClientboundEntityPositionSyncPacket withId(int id) {
        return this.id == id ? this : new ClientboundEntityPositionSyncPacket(id, this.position, this.deltaMovement, this.yRot, this.xRot, this.onGround);
    }

    public @NonNull ClientboundEntityPositionSyncPacket withPosition(Vector3d position) {
        return this.position == position ? this : new ClientboundEntityPositionSyncPacket(this.id, position, this.deltaMovement, this.yRot, this.xRot, this.onGround);
    }

    public @NonNull ClientboundEntityPositionSyncPacket withDeltaMovement(Vector3d deltaMovement) {
        return this.deltaMovement == deltaMovement ? this : new ClientboundEntityPositionSyncPacket(this.id, this.position, deltaMovement, this.yRot, this.xRot, this.onGround);
    }

    public @NonNull ClientboundEntityPositionSyncPacket withYRot(float yRot) {
        return this.yRot == yRot ? this : new ClientboundEntityPositionSyncPacket(this.id, this.position, this.deltaMovement, yRot, this.xRot, this.onGround);
    }

    public @NonNull ClientboundEntityPositionSyncPacket withXRot(float xRot) {
        return this.xRot == xRot ? this : new ClientboundEntityPositionSyncPacket(this.id, this.position, this.deltaMovement, this.yRot, xRot, this.onGround);
    }

    public @NonNull ClientboundEntityPositionSyncPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ClientboundEntityPositionSyncPacket(this.id, this.position, this.deltaMovement, this.yRot, this.xRot, onGround);
    }

    public ClientboundEntityPositionSyncPacket(int id, Vector3d position, Vector3d deltaMovement, float yRot, float xRot, boolean onGround) {
        this.id = id;
        this.position = position;
        this.deltaMovement = deltaMovement;
        this.yRot = yRot;
        this.xRot = xRot;
        this.onGround = onGround;
    }
}

