/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Animation;

public class ClientboundAnimatePacket
implements MinecraftPacket {
    private final int entityId;
    private final @Nullable Animation animation;

    public ClientboundAnimatePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.entityId = helper.readVarInt(in);
        this.animation = Animation.from(in.readUnsignedByte());
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.entityId);
        if (this.animation == null) {
            out.writeByte(-1);
        } else {
            out.writeByte(this.animation.getId());
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public @Nullable Animation getAnimation() {
        return this.animation;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAnimatePacket)) {
            return false;
        }
        ClientboundAnimatePacket other = (ClientboundAnimatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        Animation this$animation = this.getAnimation();
        Animation other$animation = other.getAnimation();
        return !(this$animation == null ? other$animation != null : !((Object)((Object)this$animation)).equals((Object)other$animation));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundAnimatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        Animation $animation = this.getAnimation();
        result = result * 59 + ($animation == null ? 43 : ((Object)((Object)$animation)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundAnimatePacket(entityId=" + this.getEntityId() + ", animation=" + this.getAnimation() + ")";
    }

    public @NonNull ClientboundAnimatePacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundAnimatePacket(entityId, this.animation);
    }

    public @NonNull ClientboundAnimatePacket withAnimation(@Nullable Animation animation) {
        return this.animation == animation ? this : new ClientboundAnimatePacket(this.entityId, animation);
    }

    public ClientboundAnimatePacket(int entityId, @Nullable Animation animation) {
        this.entityId = entityId;
        this.animation = animation;
    }
}

