/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.common.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundKeepAlivePacket
implements MinecraftPacket {
    private final long pingId;

    public ClientboundKeepAlivePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.pingId = in.readLong();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeLong(this.pingId);
    }

    public long getPingId() {
        return this.pingId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundKeepAlivePacket)) {
            return false;
        }
        ClientboundKeepAlivePacket other = (ClientboundKeepAlivePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getPingId() == other.getPingId();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundKeepAlivePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pingId = this.getPingId();
        result = result * 59 + (int)($pingId >>> 32 ^ $pingId);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundKeepAlivePacket(pingId=" + this.getPingId() + ")";
    }

    public @NonNull ClientboundKeepAlivePacket withPingId(long pingId) {
        return this.pingId == pingId ? this : new ClientboundKeepAlivePacket(pingId);
    }

    public ClientboundKeepAlivePacket(long pingId) {
        this.pingId = pingId;
    }
}

