/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.metadata;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import lombok.NonNull;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;

public abstract class EntityMetadata<V, T extends MetadataType<V>> {
    protected final int id;
    @NonNull
    protected final T type;

    public abstract V getValue();

    public void write(MinecraftCodecHelper helper, ByteBuf out) {
        ((MetadataType)this.type).writeMetadata(helper, out, this.getValue());
    }

    public String toString() {
        return "EntityMetadata(id=" + this.id + ", type=" + this.type + ", value=" + this.getValue().toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityMetadata)) {
            return false;
        }
        EntityMetadata that = (EntityMetadata)o;
        return this.id == that.id && this.type == that.type && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.getValue());
    }

    public int getId() {
        return this.id;
    }

    @NonNull
    public T getType() {
        return this.type;
    }

    public EntityMetadata(int id, @NonNull T type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.id = id;
        this.type = type;
    }
}

