/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.attribute;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeModifier;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;

public class Attribute {
    @lombok.NonNull
    private final AttributeType type;
    private final double value;
    @lombok.NonNull
    private final List<AttributeModifier> modifiers;

    public Attribute(@lombok.NonNull AttributeType type) {
        this(type, 0.0);
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public Attribute(@lombok.NonNull AttributeType type, double value) {
        this(type, value, new ArrayList<AttributeModifier>());
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    @lombok.NonNull
    public AttributeType getType() {
        return this.type;
    }

    public double getValue() {
        return this.value;
    }

    @lombok.NonNull
    public List<AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        AttributeType this$type = this.getType();
        AttributeType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<AttributeModifier> this$modifiers = this.getModifiers();
        List<AttributeModifier> other$modifiers = other.getModifiers();
        return !(this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Attribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        AttributeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<AttributeModifier> $modifiers = this.getModifiers();
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "Attribute(type=" + this.getType() + ", value=" + this.getValue() + ", modifiers=" + this.getModifiers() + ")";
    }

    public Attribute(@lombok.NonNull AttributeType type, double value, @lombok.NonNull List<AttributeModifier> modifiers) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (modifiers == null) {
            throw new NullPointerException("modifiers is marked non-null but is null");
        }
        this.type = type;
        this.value = value;
        this.modifiers = modifiers;
    }
}

