/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.jetbrains.annotations.Contract;

public class NbtComponentSerializer {
    private static final Set<String> BOOLEAN_TYPES = Set.of("interpret", "bold", "italic", "underlined", "strikethrough", "obfuscated");
    private static final List<Pair<String, String>> COMPONENT_TYPES = List.of(new Pair<String, String>("text", "text"), new Pair<String, String>("translatable", "translate"), new Pair<String, String>("score", "score"), new Pair<String, String>("selector", "selector"), new Pair<String, String>("keybind", "keybind"), new Pair<String, String>("nbt", "nbt"));

    private NbtComponentSerializer() {
    }

    @Contract(value="null -> null")
    public static JsonElement tagComponentToJson(@Nullable Object tag) {
        return NbtComponentSerializer.convertToJson(null, tag);
    }

    public static @Nullable Object jsonComponentToTag(@Nullable JsonElement component) {
        return NbtComponentSerializer.convertToTag(component);
    }

    @Contract(value="null -> null")
    private static Object convertToTag(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            NbtMapBuilder tag = NbtMap.builder();
            JsonObject jsonObject = element.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                NbtComponentSerializer.convertObjectEntry((String)entry.getKey(), (JsonElement)entry.getValue(), tag);
            }
            NbtComponentSerializer.addComponentType(jsonObject, tag);
            return tag.build();
        }
        if (element.isJsonArray()) {
            return NbtComponentSerializer.convertJsonArray(element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isBoolean()) {
                return (byte)(primitive.getAsBoolean() ? 1 : 0);
            }
            Number number = primitive.getAsNumber();
            if (number instanceof Integer) {
                return number.intValue();
            }
            if (number instanceof Byte) {
                return number.byteValue();
            }
            if (number instanceof Short) {
                return number.shortValue();
            }
            if (number instanceof Long) {
                return number.longValue();
            }
            if (number instanceof Double) {
                return number.doubleValue();
            }
            if (number instanceof Float) {
                return Float.valueOf(number.floatValue());
            }
            if (number instanceof LazilyParsedNumber) {
                return number.intValue();
            }
            return number.intValue();
        }
        throw new IllegalArgumentException("Unhandled json type " + element.getClass().getSimpleName() + " with value " + element.getAsString());
    }

    private static NbtList<?> convertJsonArray(JsonArray array) {
        NbtListBuilder listBuilder = null;
        for (JsonElement entry : array) {
            Object convertedEntryTag = NbtComponentSerializer.convertToTag(entry);
            NbtType convertedTagType = NbtType.byClass(convertedEntryTag.getClass());
            if (listBuilder == null) {
                listBuilder = new NbtListBuilder(convertedTagType);
            }
            if (listBuilder.type != convertedTagType) {
                listBuilder = null;
                break;
            }
            listBuilder.addUnsafe(convertedEntryTag);
        }
        if (listBuilder != null) {
            return listBuilder.build();
        }
        NbtListBuilder<NbtMap> processedListTag = new NbtListBuilder<NbtMap>(NbtType.COMPOUND);
        for (JsonElement entry : array) {
            Object convertedTag = NbtComponentSerializer.convertToTag(entry);
            if (convertedTag instanceof NbtMap) {
                NbtMap nbtMap = (NbtMap)convertedTag;
                processedListTag.add(nbtMap);
                continue;
            }
            NbtMapBuilder compoundTag = NbtMap.builder();
            compoundTag.put("type", (Object)"text");
            if (convertedTag instanceof NbtList) {
                NbtList list = (NbtList)convertedTag;
                compoundTag.put("text", (Object)"");
                compoundTag.put("extra", (Object)list);
            } else {
                compoundTag.put("text", (Object)NbtComponentSerializer.stringValue(convertedTag));
            }
            processedListTag.add(compoundTag.build());
        }
        return processedListTag.build();
    }

    private static void convertObjectEntry(String key, JsonElement value, NbtMapBuilder tag) {
        UUID uuid;
        JsonObject hoverEvent;
        JsonElement id;
        if (key.equals("contents") && value.isJsonObject() && (id = (hoverEvent = value.getAsJsonObject()).get("id")) != null && id.isJsonPrimitive() && (uuid = NbtComponentSerializer.parseUUID(id.getAsString())) != null) {
            hoverEvent.remove("id");
            NbtMapBuilder convertedTag = ((NbtMap)NbtComponentSerializer.convertToTag(value)).toBuilder();
            convertedTag.put("id", (Object)NbtComponentSerializer.toIntArray(uuid));
            tag.put(key, (Object)convertedTag.build());
            return;
        }
        tag.put(key, NbtComponentSerializer.convertToTag(value));
    }

    private static void addComponentType(JsonObject object, NbtMapBuilder tag) {
        if (object.has("type")) {
            return;
        }
        for (Pair<String, String> pair : COMPONENT_TYPES) {
            if (!object.has((String)pair.value)) continue;
            tag.put("type", pair.key);
            return;
        }
    }

    private static @Nullable JsonElement convertToJson(@Nullable String key, @Nullable Object tag) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof NbtMap) {
            NbtMap nbtMap = (NbtMap)tag;
            JsonObject object = new JsonObject();
            if (!"value".equals(key)) {
                NbtComponentSerializer.removeComponentType(object);
            }
            for (Map.Entry entry : nbtMap.entrySet()) {
                NbtComponentSerializer.convertNbtMapEntry((String)entry.getKey(), entry.getValue(), object);
            }
            return object;
        }
        if (tag instanceof NbtList) {
            NbtList list = (NbtList)tag;
            JsonArray array = new JsonArray();
            for (Object listEntry : list) {
                array.add(NbtComponentSerializer.convertToJson(null, listEntry));
            }
            return array;
        }
        if (tag instanceof Number) {
            Number number = (Number)tag;
            if (key != null && BOOLEAN_TYPES.contains(key)) {
                return new JsonPrimitive(Boolean.valueOf(number.byteValue() != 0));
            }
            return new JsonPrimitive(number);
        }
        if (tag instanceof String) {
            String string = (String)tag;
            return new JsonPrimitive(string);
        }
        if (tag instanceof byte[]) {
            byte[] arrayTag = (byte[])tag;
            JsonArray array = new JsonArray();
            for (byte num : arrayTag) {
                array.add((Number)num);
            }
            return array;
        }
        if (tag instanceof int[]) {
            int[] arrayTag = (int[])tag;
            JsonArray array = new JsonArray();
            for (int num : arrayTag) {
                array.add((Number)num);
            }
            return array;
        }
        if (tag instanceof long[]) {
            long[] arrayTag = (long[])tag;
            JsonArray array = new JsonArray();
            for (long num : arrayTag) {
                array.add((Number)num);
            }
            return array;
        }
        throw new IllegalArgumentException("Unhandled tag type " + tag.getClass().getSimpleName());
    }

    private static void convertNbtMapEntry(String key, Object tag, JsonObject object) {
        NbtMap showEntity;
        Object idTag;
        if (key.equals("contents") && tag instanceof NbtMap && (idTag = (showEntity = (NbtMap)tag).get((Object)"id")) instanceof int[]) {
            int[] array = (int[])idTag;
            JsonObject convertedElement = (JsonObject)NbtComponentSerializer.convertToJson(key, tag);
            UUID uuid = NbtComponentSerializer.fromIntArray(array);
            convertedElement.addProperty("id", uuid.toString());
            object.add(key, (JsonElement)convertedElement);
            return;
        }
        object.add(key.isEmpty() ? "text" : key, NbtComponentSerializer.convertToJson(key, tag));
    }

    private static void removeComponentType(JsonObject object) {
        JsonElement type = object.remove("type");
        if (type == null || !type.isJsonPrimitive()) {
            return;
        }
        String typeString = type.getAsString();
        for (Pair<String, String> pair : COMPONENT_TYPES) {
            if (((String)pair.key).equals(typeString)) continue;
            object.remove((String)pair.value);
        }
    }

    public static UUID fromIntArray(int[] parts) {
        if (parts.length != 4) {
            return new UUID(0L, 0L);
        }
        return new UUID((long)parts[0] << 32 | (long)parts[1] & 0xFFFFFFFFL, (long)parts[2] << 32 | (long)parts[3] & 0xFFFFFFFFL);
    }

    public static int[] toIntArray(UUID uuid) {
        return NbtComponentSerializer.toIntArray(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static int[] toIntArray(long msb, long lsb) {
        return new int[]{(int)(msb >> 32), (int)msb, (int)(lsb >> 32), (int)lsb};
    }

    public static @Nullable UUID parseUUID(String uuidString) {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static String stringValue(Object tag) {
        if (tag instanceof byte[]) {
            byte[] bytes = (byte[])tag;
            return Arrays.toString(bytes);
        }
        if (tag instanceof Byte) {
            Byte byteTag = (Byte)tag;
            return Byte.toString(byteTag);
        }
        if (tag instanceof Double) {
            Double doubleTag = (Double)tag;
            return Double.toString(doubleTag);
        }
        if (tag instanceof Float) {
            Float floatTag = (Float)tag;
            return Float.toString(floatTag.floatValue());
        }
        if (tag instanceof int[]) {
            int[] intArray = (int[])tag;
            return Arrays.toString(intArray);
        }
        if (tag instanceof Integer) {
            Integer integer = (Integer)tag;
            return Integer.toString(integer);
        }
        if (tag instanceof long[]) {
            long[] longs = (long[])tag;
            return Arrays.toString(longs);
        }
        if (tag instanceof Long) {
            Long longTag = (Long)tag;
            return Long.toString(longTag);
        }
        if (tag instanceof Short) {
            Short shortTag = (Short)tag;
            return Short.toString(shortTag);
        }
        if (tag instanceof String) {
            String string = (String)tag;
            return string;
        }
        return tag.toString();
    }

    private static class NbtListBuilder<T> {
        private final NbtType<T> type;
        private final List<T> list = new ArrayList<T>();

        public void add(T value) {
            this.list.add(value);
        }

        public void addUnsafe(Object value) {
            this.add(this.type.getTagClass().cast(value));
        }

        public NbtList<T> build() {
            return new NbtList(this.type, this.list);
        }

        public NbtListBuilder(NbtType<T> type) {
            this.type = type;
        }
    }

    private static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

