/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.helper;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageEncoder;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.function.Supplier;
import org.geysermc.mcprotocollib.network.BuiltinFlags;
import org.geysermc.mcprotocollib.network.ProxyInfo;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.helper.TransportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHelper {
    private static final Logger log = LoggerFactory.getLogger(NettyHelper.class);
    private static final String IP_REGEX = "\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b";

    public static SocketAddress resolveAddress(Session session, Supplier<EventLoop> eventLoop, SocketAddress address) {
        InetSocketAddress inetAddress;
        if (address instanceof InetSocketAddress && (inetAddress = (InetSocketAddress)address).isUnresolved()) {
            return NettyHelper.resolveAddress(session, eventLoop.get(), inetAddress.getHostString(), inetAddress.getPort());
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketAddress resolveAddress(Session session, EventLoop eventLoop, String host, int port) {
        String name = session.getPacketProtocol().getSRVRecordPrefix() + "._tcp." + host;
        log.debug("Attempting SRV lookup for \"{}\".", (Object)name);
        if (session.getFlag(BuiltinFlags.ATTEMPT_SRV_RESOLVE, true).booleanValue() && !host.matches(IP_REGEX) && !host.equalsIgnoreCase("localhost")) {
            try (DnsNameResolver resolver = new DnsNameResolverBuilder(eventLoop).channelFactory(TransportHelper.TRANSPORT_TYPE.datagramChannelFactory()).build();){
                AddressedEnvelope envelope = (AddressedEnvelope)resolver.query((DnsQuestion)new DefaultDnsQuestion(name, DnsRecordType.SRV)).get();
                try {
                    DnsResponse response = (DnsResponse)envelope.content();
                    if (response.count(DnsSection.ANSWER) > 0) {
                        DefaultDnsRawRecord record = (DefaultDnsRawRecord)response.recordAt(DnsSection.ANSWER, 0);
                        if (record.type() == DnsRecordType.SRV) {
                            ByteBuf buf = record.content();
                            buf.skipBytes(4);
                            int tempPort = buf.readUnsignedShort();
                            String tempHost = DefaultDnsRecordDecoder.decodeName((ByteBuf)buf);
                            if (tempHost.endsWith(".")) {
                                tempHost = tempHost.substring(0, tempHost.length() - 1);
                            }
                            log.debug("Found SRV record containing \"{}:{}\".", (Object)tempHost, (Object)tempPort);
                            host = tempHost;
                            port = tempPort;
                        } else {
                            log.debug("Received non-SRV record in response.");
                        }
                    } else {
                        log.debug("No SRV record found.");
                    }
                }
                finally {
                    envelope.release();
                }
            }
            catch (Exception e) {
                log.debug("Failed to resolve SRV record.", (Throwable)e);
            }
        } else {
            log.debug("Not resolving SRV record for {}", (Object)host);
        }
        try {
            InetAddress resolved = InetAddress.getByName(host);
            log.debug("Resolved {} -> {}", (Object)host, (Object)resolved.getHostAddress());
            return new InetSocketAddress(resolved, port);
        }
        catch (UnknownHostException e) {
            log.debug("Failed to resolve host, letting Netty do it instead.", (Throwable)e);
            return InetSocketAddress.createUnresolved(host, port);
        }
    }

    public static void initializeHAProxySupport(Session session, final Channel channel) {
        final InetSocketAddress clientAddress = session.getFlag(BuiltinFlags.CLIENT_PROXIED_ADDRESS);
        if (clientAddress == null) {
            return;
        }
        channel.pipeline().addLast("proxy-protocol-encoder", (ChannelHandler)HAProxyMessageEncoder.INSTANCE);
        channel.pipeline().addLast("proxy-protocol-packet-sender", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                int destinationPort;
                String destinationAddress;
                InetSocketAddress inetRemoteAddress;
                HAProxyProxiedProtocol proxiedProtocol = NettyHelper.getProxiedProtocol(clientAddress);
                SocketAddress remoteAddress = ctx.channel().remoteAddress();
                if (remoteAddress instanceof InetSocketAddress && NettyHelper.getProxiedProtocol(inetRemoteAddress = (InetSocketAddress)remoteAddress) == proxiedProtocol) {
                    destinationAddress = inetRemoteAddress.getAddress().getHostAddress();
                    destinationPort = inetRemoteAddress.getPort();
                } else {
                    switch (proxiedProtocol) {
                        case TCP4: {
                            destinationAddress = "0.0.0.0";
                            destinationPort = 0;
                            break;
                        }
                        case TCP6: {
                            destinationAddress = "0:0:0:0:0:0:0:0";
                            destinationPort = 0;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported proxied protocol: " + proxiedProtocol);
                        }
                    }
                    log.debug("Remote address {} is not of the same type as the client address {} - using arbitrary values for destination address and port", (Object)remoteAddress, (Object)clientAddress);
                }
                ctx.channel().writeAndFlush((Object)new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, proxiedProtocol, clientAddress.getAddress().getHostAddress(), destinationAddress, clientAddress.getPort(), destinationPort)).addListener(future -> channel.pipeline().remove("proxy-protocol-encoder"));
                ctx.pipeline().remove((ChannelHandler)this);
                super.channelActive(ctx);
            }
        });
    }

    private static HAProxyProxiedProtocol getProxiedProtocol(InetSocketAddress socketAddress) {
        if (socketAddress.getAddress() instanceof Inet4Address) {
            return HAProxyProxiedProtocol.TCP4;
        }
        if (socketAddress.getAddress() instanceof Inet6Address) {
            return HAProxyProxiedProtocol.TCP6;
        }
        return HAProxyProxiedProtocol.UNKNOWN;
    }

    public static void addProxy(ProxyInfo proxy, ChannelPipeline pipeline) {
        if (proxy == null) {
            return;
        }
        switch (proxy.type()) {
            case HTTP: {
                if (proxy.username() != null && proxy.password() != null) {
                    pipeline.addLast("proxy", (ChannelHandler)new HttpProxyHandler(proxy.address(), proxy.username(), proxy.password()));
                    break;
                }
                pipeline.addLast("proxy", (ChannelHandler)new HttpProxyHandler(proxy.address()));
                break;
            }
            case SOCKS4: {
                if (proxy.username() != null) {
                    pipeline.addLast("proxy", (ChannelHandler)new Socks4ProxyHandler(proxy.address(), proxy.username()));
                    break;
                }
                pipeline.addLast("proxy", (ChannelHandler)new Socks4ProxyHandler(proxy.address()));
                break;
            }
            case SOCKS5: {
                if (proxy.username() != null && proxy.password() != null) {
                    pipeline.addLast("proxy", (ChannelHandler)new Socks5ProxyHandler(proxy.address(), proxy.username(), proxy.password()));
                    break;
                }
                pipeline.addLast("proxy", (ChannelHandler)new Socks5ProxyHandler(proxy.address()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported proxy type: " + proxy.type());
            }
        }
    }
}

