/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.auth;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.List;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.auth.util.HTTPUtils;
import org.geysermc.mcprotocollib.auth.util.UUIDUtils;
import org.geysermc.mcprotocollib.network.ProxyInfo;

public class SessionService {
    private static final URI JOIN_ENDPOINT = URI.create("https://sessionserver.mojang.com/session/minecraft/join");
    private static final String HAS_JOINED_ENDPOINT = "https://sessionserver.mojang.com/session/minecraft/hasJoined?username=%s&serverId=%s";
    private static final String PROFILE_ENDPOINT = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";
    private ProxyInfo proxy;

    public static String getServerId(String base, PublicKey publicKey, SecretKey secretKey) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(base.getBytes(StandardCharsets.ISO_8859_1));
            digest.update(secretKey.getEncoded());
            digest.update(publicKey.getEncoded());
            return new BigInteger(digest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Server ID hash algorithm unavailable.", e);
        }
    }

    public void joinServer(GameProfile profile, String authenticationToken, String serverId) throws IOException {
        JoinServerRequest request = new JoinServerRequest(authenticationToken, profile.getId(), serverId);
        HTTPUtils.makeRequest(this.getProxy(), JOIN_ENDPOINT, request, null);
    }

    public GameProfile getProfileByServer(String name, String serverId) throws IOException {
        HasJoinedResponse response = HTTPUtils.makeRequest(this.getProxy(), URI.create(String.format(HAS_JOINED_ENDPOINT, URLEncoder.encode(name, StandardCharsets.UTF_8), URLEncoder.encode(serverId, StandardCharsets.UTF_8))), null, HasJoinedResponse.class);
        if (response != null && response.id != null) {
            GameProfile result = new GameProfile(response.id, name);
            result.setProperties(response.properties);
            return result;
        }
        return null;
    }

    public void fillProfileProperties(GameProfile profile) throws IOException {
        if (profile.getId() == null) {
            return;
        }
        MinecraftProfileResponse response = HTTPUtils.makeRequest(this.getProxy(), URI.create(String.format(PROFILE_ENDPOINT, UUIDUtils.convertToNoDashes(profile.getId()))), null, MinecraftProfileResponse.class);
        if (response == null) {
            throw new IllegalStateException("Couldn't fetch profile properties for " + profile + " as the profile does not exist.");
        }
        profile.setProperties(response.properties);
    }

    public String toString() {
        return "SessionService{}";
    }

    public void setProxy(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    public ProxyInfo getProxy() {
        return this.proxy;
    }

    private record JoinServerRequest(String accessToken, UUID selectedProfile, String serverId) {
    }

    private static class HasJoinedResponse {
        public UUID id;
        public List<GameProfile.Property> properties;

        private HasJoinedResponse() {
        }
    }

    private static class MinecraftProfileResponse {
        public UUID id;
        public String name;
        public List<GameProfile.Property> properties;

        private MinecraftProfileResponse() {
        }
    }
}

