/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.ArgumentSignature;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class ServerboundChatCommandPacket
implements MinecraftPacket {
    private final String command;
    private final long timeStamp;
    private final long salt;
    private final List<ArgumentSignature> signatures;
    private final int offset;
    private final BitSet acknowledgedMessages;

    public ServerboundChatCommandPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.command = helper.readString(in);
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        this.signatures = new ArrayList<ArgumentSignature>();
        int signatureCount = Math.min(helper.readVarInt(in), 8);
        for (int i = 0; i < signatureCount; ++i) {
            byte[] signature = new byte[256];
            this.signatures.add(new ArgumentSignature(helper.readString(in, 16), signature));
            in.readBytes(signature);
        }
        this.offset = helper.readVarInt(in);
        this.acknowledgedMessages = helper.readFixedBitSet(in, 20);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeString(out, this.command);
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        helper.writeVarInt(out, this.signatures.size());
        for (ArgumentSignature signature : this.signatures) {
            helper.writeString(out, signature.getName());
            out.writeBytes(signature.getSignature());
        }
        helper.writeVarInt(out, this.offset);
        helper.writeFixedBitSet(out, this.acknowledgedMessages, 20);
    }

    public String getCommand() {
        return this.command;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public List<ArgumentSignature> getSignatures() {
        return this.signatures;
    }

    public int getOffset() {
        return this.offset;
    }

    public BitSet getAcknowledgedMessages() {
        return this.acknowledgedMessages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChatCommandPacket)) {
            return false;
        }
        ServerboundChatCommandPacket other = (ServerboundChatCommandPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        List<ArgumentSignature> this$signatures = this.getSignatures();
        List<ArgumentSignature> other$signatures = other.getSignatures();
        if (this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures)) {
            return false;
        }
        BitSet this$acknowledgedMessages = this.getAcknowledgedMessages();
        BitSet other$acknowledgedMessages = other.getAcknowledgedMessages();
        return !(this$acknowledgedMessages == null ? other$acknowledgedMessages != null : !((Object)this$acknowledgedMessages).equals(other$acknowledgedMessages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundChatCommandPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + this.getOffset();
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        List<ArgumentSignature> $signatures = this.getSignatures();
        result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
        BitSet $acknowledgedMessages = this.getAcknowledgedMessages();
        result = result * 59 + ($acknowledgedMessages == null ? 43 : ((Object)$acknowledgedMessages).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundChatCommandPacket(command=" + this.getCommand() + ", timeStamp=" + this.getTimeStamp() + ", salt=" + this.getSalt() + ", signatures=" + this.getSignatures() + ", offset=" + this.getOffset() + ", acknowledgedMessages=" + this.getAcknowledgedMessages() + ")";
    }

    public ServerboundChatCommandPacket withCommand(String command) {
        return this.command == command ? this : new ServerboundChatCommandPacket(command, this.timeStamp, this.salt, this.signatures, this.offset, this.acknowledgedMessages);
    }

    public ServerboundChatCommandPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ServerboundChatCommandPacket(this.command, timeStamp, this.salt, this.signatures, this.offset, this.acknowledgedMessages);
    }

    public ServerboundChatCommandPacket withSalt(long salt) {
        return this.salt == salt ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, salt, this.signatures, this.offset, this.acknowledgedMessages);
    }

    public ServerboundChatCommandPacket withSignatures(List<ArgumentSignature> signatures) {
        return this.signatures == signatures ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, this.salt, signatures, this.offset, this.acknowledgedMessages);
    }

    public ServerboundChatCommandPacket withOffset(int offset) {
        return this.offset == offset ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, this.salt, this.signatures, offset, this.acknowledgedMessages);
    }

    public ServerboundChatCommandPacket withAcknowledgedMessages(BitSet acknowledgedMessages) {
        return this.acknowledgedMessages == acknowledgedMessages ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, this.salt, this.signatures, this.offset, acknowledgedMessages);
    }

    public ServerboundChatCommandPacket(String command, long timeStamp, long salt, List<ArgumentSignature> signatures, int offset, BitSet acknowledgedMessages) {
        this.command = command;
        this.timeStamp = timeStamp;
        this.salt = salt;
        this.signatures = signatures;
        this.offset = offset;
        this.acknowledgedMessages = acknowledgedMessages;
    }
}

