/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.player.BlockBreakStage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import org.cloudburstmc.math.vector.Vector3i;

public class ClientboundBlockDestructionPacket
implements MinecraftPacket {
    private final int breakerEntityId;
    @NonNull
    private final Vector3i position;
    @NonNull
    private final BlockBreakStage stage;

    public ClientboundBlockDestructionPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.breakerEntityId = helper.readVarInt(in);
        this.position = helper.readPosition(in);
        this.stage = helper.readBlockBreakStage(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.breakerEntityId);
        helper.writePosition(out, this.position);
        helper.writeBlockBreakStage(out, this.stage);
    }

    public int getBreakerEntityId() {
        return this.breakerEntityId;
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @NonNull
    public BlockBreakStage getStage() {
        return this.stage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockDestructionPacket)) {
            return false;
        }
        ClientboundBlockDestructionPacket other = (ClientboundBlockDestructionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBreakerEntityId() != other.getBreakerEntityId()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        BlockBreakStage this$stage = this.getStage();
        BlockBreakStage other$stage = other.getStage();
        return !(this$stage == null ? other$stage != null : !((Object)((Object)this$stage)).equals((Object)other$stage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundBlockDestructionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBreakerEntityId();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        BlockBreakStage $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : ((Object)((Object)$stage)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundBlockDestructionPacket(breakerEntityId=" + this.getBreakerEntityId() + ", position=" + this.getPosition() + ", stage=" + (Object)((Object)this.getStage()) + ")";
    }

    public ClientboundBlockDestructionPacket withBreakerEntityId(int breakerEntityId) {
        return this.breakerEntityId == breakerEntityId ? this : new ClientboundBlockDestructionPacket(breakerEntityId, this.position, this.stage);
    }

    public ClientboundBlockDestructionPacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundBlockDestructionPacket(this.breakerEntityId, position, this.stage);
    }

    public ClientboundBlockDestructionPacket withStage(@NonNull BlockBreakStage stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return this.stage == stage ? this : new ClientboundBlockDestructionPacket(this.breakerEntityId, this.position, stage);
    }

    public ClientboundBlockDestructionPacket(int breakerEntityId, @NonNull Vector3i position, @NonNull BlockBreakStage stage) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        this.breakerEntityId = breakerEntityId;
        this.position = position;
        this.stage = stage;
    }
}

