/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ClientboundContainerSetSlotPacket
implements MinecraftPacket {
    private final int containerId;
    private final int stateId;
    private final int slot;
    private final ItemStack item;

    public ClientboundContainerSetSlotPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.containerId = in.readUnsignedByte();
        this.stateId = helper.readVarInt(in);
        this.slot = in.readShort();
        this.item = helper.readItemStack(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeByte(this.containerId);
        helper.writeVarInt(out, this.stateId);
        out.writeShort(this.slot);
        helper.writeItemStack(out, this.item);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getStateId() {
        return this.stateId;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundContainerSetSlotPacket)) {
            return false;
        }
        ClientboundContainerSetSlotPacket other = (ClientboundContainerSetSlotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getStateId() != other.getStateId()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        ItemStack this$item = this.getItem();
        ItemStack other$item = other.getItem();
        return !(this$item == null ? other$item != null : !((Object)this$item).equals(other$item));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundContainerSetSlotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getStateId();
        result = result * 59 + this.getSlot();
        ItemStack $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundContainerSetSlotPacket(containerId=" + this.getContainerId() + ", stateId=" + this.getStateId() + ", slot=" + this.getSlot() + ", item=" + this.getItem() + ")";
    }

    public ClientboundContainerSetSlotPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundContainerSetSlotPacket(containerId, this.stateId, this.slot, this.item);
    }

    public ClientboundContainerSetSlotPacket withStateId(int stateId) {
        return this.stateId == stateId ? this : new ClientboundContainerSetSlotPacket(this.containerId, stateId, this.slot, this.item);
    }

    public ClientboundContainerSetSlotPacket withSlot(int slot) {
        return this.slot == slot ? this : new ClientboundContainerSetSlotPacket(this.containerId, this.stateId, slot, this.item);
    }

    public ClientboundContainerSetSlotPacket withItem(ItemStack item) {
        return this.item == item ? this : new ClientboundContainerSetSlotPacket(this.containerId, this.stateId, this.slot, item);
    }

    public ClientboundContainerSetSlotPacket(int containerId, int stateId, int slot, ItemStack item) {
        this.containerId = containerId;
        this.stateId = stateId;
        this.slot = slot;
        this.item = item;
    }
}

