/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;

public class ClientboundUpdateEnabledFeaturesPacket
implements MinecraftPacket {
    private final String[] features;

    public ClientboundUpdateEnabledFeaturesPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.features = new String[helper.readVarInt(in)];
        for (int i = 0; i < this.features.length; ++i) {
            this.features[i] = helper.readString(in);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.features.length);
        for (String feature : this.features) {
            helper.writeString(out, feature);
        }
    }

    public String[] getFeatures() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateEnabledFeaturesPacket)) {
            return false;
        }
        ClientboundUpdateEnabledFeaturesPacket other = (ClientboundUpdateEnabledFeaturesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getFeatures(), other.getFeatures());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateEnabledFeaturesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getFeatures());
        return result;
    }

    public String toString() {
        return "ClientboundUpdateEnabledFeaturesPacket(features=" + Arrays.deepToString(this.getFeatures()) + ")";
    }

    public ClientboundUpdateEnabledFeaturesPacket withFeatures(String[] features) {
        return this.features == features ? this : new ClientboundUpdateEnabledFeaturesPacket(features);
    }

    public ClientboundUpdateEnabledFeaturesPacket(String[] features) {
        this.features = features;
    }
}

