/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.chat.ChatFilterType;
import com.github.steveice10.mc.protocol.data.game.chat.MessageSignature;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ClientboundPlayerChatPacket
implements MinecraftPacket {
    private final UUID sender;
    private final int index;
    private final byte @Nullable [] messageSignature;
    private final String content;
    private final long timeStamp;
    private final long salt;
    private final List<MessageSignature> lastSeenMessages;
    @Nullable
    private final Component unsignedContent;
    private final ChatFilterType filterMask;
    private final int chatType;
    private final Component name;
    @Nullable
    private final Component targetName;

    public ClientboundPlayerChatPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.sender = helper.readUUID(in);
        this.index = helper.readVarInt(in);
        if (in.readBoolean()) {
            this.messageSignature = new byte[256];
            in.readBytes(this.messageSignature);
        } else {
            this.messageSignature = null;
        }
        this.content = helper.readString(in, 256);
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        this.lastSeenMessages = new ArrayList<MessageSignature>();
        int seenMessageCount = Math.min(helper.readVarInt(in), 20);
        for (int i = 0; i < seenMessageCount; ++i) {
            this.lastSeenMessages.add(MessageSignature.read(in, helper));
        }
        this.unsignedContent = helper.readNullable(in, helper::readComponent);
        this.filterMask = ChatFilterType.from(helper.readVarInt(in));
        this.chatType = helper.readVarInt(in);
        this.name = helper.readComponent(in);
        this.targetName = helper.readNullable(in, helper::readComponent);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeUUID(out, this.sender);
        helper.writeVarInt(out, this.index);
        out.writeBoolean(this.messageSignature != null);
        if (this.messageSignature != null) {
            out.writeBytes(this.messageSignature);
        }
        helper.writeString(out, this.content);
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        helper.writeVarInt(out, this.lastSeenMessages.size());
        for (MessageSignature messageSignature : this.lastSeenMessages) {
            helper.writeVarInt(out, messageSignature.getId() + 1);
            if (messageSignature.getMessageSignature() == null) continue;
            out.writeBytes(messageSignature.getMessageSignature());
        }
        helper.writeNullable(out, this.unsignedContent, helper::writeComponent);
        helper.writeVarInt(out, this.filterMask.ordinal());
        helper.writeVarInt(out, this.chatType);
        helper.writeComponent(out, this.name);
        helper.writeNullable(out, this.targetName, helper::writeComponent);
    }

    public UUID getSender() {
        return this.sender;
    }

    public int getIndex() {
        return this.index;
    }

    public byte @Nullable [] getMessageSignature() {
        return this.messageSignature;
    }

    public String getContent() {
        return this.content;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public List<MessageSignature> getLastSeenMessages() {
        return this.lastSeenMessages;
    }

    @Nullable
    public Component getUnsignedContent() {
        return this.unsignedContent;
    }

    public ChatFilterType getFilterMask() {
        return this.filterMask;
    }

    public int getChatType() {
        return this.chatType;
    }

    public Component getName() {
        return this.name;
    }

    @Nullable
    public Component getTargetName() {
        return this.targetName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerChatPacket)) {
            return false;
        }
        ClientboundPlayerChatPacket other = (ClientboundPlayerChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.getChatType() != other.getChatType()) {
            return false;
        }
        UUID this$sender = this.getSender();
        UUID other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        if (!Arrays.equals(this.getMessageSignature(), other.getMessageSignature())) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<MessageSignature> this$lastSeenMessages = this.getLastSeenMessages();
        List<MessageSignature> other$lastSeenMessages = other.getLastSeenMessages();
        if (this$lastSeenMessages == null ? other$lastSeenMessages != null : !((Object)this$lastSeenMessages).equals(other$lastSeenMessages)) {
            return false;
        }
        Component this$unsignedContent = this.getUnsignedContent();
        Component other$unsignedContent = other.getUnsignedContent();
        if (this$unsignedContent == null ? other$unsignedContent != null : !this$unsignedContent.equals(other$unsignedContent)) {
            return false;
        }
        ChatFilterType this$filterMask = this.getFilterMask();
        ChatFilterType other$filterMask = other.getFilterMask();
        if (this$filterMask == null ? other$filterMask != null : !((Object)((Object)this$filterMask)).equals((Object)other$filterMask)) {
            return false;
        }
        Component this$name = this.getName();
        Component other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Component this$targetName = this.getTargetName();
        Component other$targetName = other.getTargetName();
        return !(this$targetName == null ? other$targetName != null : !this$targetName.equals(other$targetName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + this.getChatType();
        UUID $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        result = result * 59 + Arrays.hashCode(this.getMessageSignature());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<MessageSignature> $lastSeenMessages = this.getLastSeenMessages();
        result = result * 59 + ($lastSeenMessages == null ? 43 : ((Object)$lastSeenMessages).hashCode());
        Component $unsignedContent = this.getUnsignedContent();
        result = result * 59 + ($unsignedContent == null ? 43 : $unsignedContent.hashCode());
        ChatFilterType $filterMask = this.getFilterMask();
        result = result * 59 + ($filterMask == null ? 43 : ((Object)((Object)$filterMask)).hashCode());
        Component $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Component $targetName = this.getTargetName();
        result = result * 59 + ($targetName == null ? 43 : $targetName.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerChatPacket(sender=" + this.getSender() + ", index=" + this.getIndex() + ", messageSignature=" + this.getMessageSignature() + ", content=" + this.getContent() + ", timeStamp=" + this.getTimeStamp() + ", salt=" + this.getSalt() + ", lastSeenMessages=" + this.getLastSeenMessages() + ", unsignedContent=" + this.getUnsignedContent() + ", filterMask=" + (Object)((Object)this.getFilterMask()) + ", chatType=" + this.getChatType() + ", name=" + this.getName() + ", targetName=" + this.getTargetName() + ")";
    }

    public ClientboundPlayerChatPacket withSender(UUID sender) {
        return this.sender == sender ? this : new ClientboundPlayerChatPacket(sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withIndex(int index) {
        return this.index == index ? this : new ClientboundPlayerChatPacket(this.sender, index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withMessageSignature(byte @Nullable [] messageSignature) {
        return this.messageSignature == messageSignature ? this : new ClientboundPlayerChatPacket(this.sender, this.index, messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withContent(String content) {
        return this.content == content ? this : new ClientboundPlayerChatPacket(this.sender, this.index, this.messageSignature, content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ClientboundPlayerChatPacket(this.sender, this.index, this.messageSignature, this.content, timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withSalt(long salt) {
        return this.salt == salt ? this : new ClientboundPlayerChatPacket(this.sender, this.index, this.messageSignature, this.content, this.timeStamp, salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withLastSeenMessages(List<MessageSignature> lastSeenMessages) {
        return this.lastSeenMessages == lastSeenMessages ? this : new ClientboundPlayerChatPacket(this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withUnsignedContent(@Nullable Component unsignedContent) {
        return this.unsignedContent == unsignedContent ? this : new ClientboundPlayerChatPacket(this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, unsignedContent, this.filterMask, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withFilterMask(ChatFilterType filterMask) {
        return this.filterMask == filterMask ? this : new ClientboundPlayerChatPacket(this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, filterMask, this.chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withChatType(int chatType) {
        return this.chatType == chatType ? this : new ClientboundPlayerChatPacket(this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, chatType, this.name, this.targetName);
    }

    public ClientboundPlayerChatPacket withName(Component name) {
        return this.name == name ? this : new ClientboundPlayerChatPacket(this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, name, this.targetName);
    }

    public ClientboundPlayerChatPacket withTargetName(@Nullable Component targetName) {
        return this.targetName == targetName ? this : new ClientboundPlayerChatPacket(this.sender, this.index, this.messageSignature, this.content, this.timeStamp, this.salt, this.lastSeenMessages, this.unsignedContent, this.filterMask, this.chatType, this.name, targetName);
    }

    public ClientboundPlayerChatPacket(UUID sender, int index, byte @Nullable [] messageSignature, String content, long timeStamp, long salt, List<MessageSignature> lastSeenMessages, @Nullable Component unsignedContent, ChatFilterType filterMask, int chatType, Component name, @Nullable Component targetName) {
        this.sender = sender;
        this.index = index;
        this.messageSignature = messageSignature;
        this.content = content;
        this.timeStamp = timeStamp;
        this.salt = salt;
        this.lastSeenMessages = lastSeenMessages;
        this.unsignedContent = unsignedContent;
        this.filterMask = filterMask;
        this.chatType = chatType;
        this.name = name;
        this.targetName = targetName;
    }
}

