/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.setting.Difficulty;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundChangeDifficultyPacket
implements MinecraftPacket {
    @NonNull
    private final Difficulty difficulty;
    private final boolean difficultyLocked;

    public ClientboundChangeDifficultyPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.difficulty = Difficulty.from(in.readUnsignedByte());
        this.difficultyLocked = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeByte(this.difficulty.ordinal());
        out.writeBoolean(this.difficultyLocked);
    }

    @NonNull
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundChangeDifficultyPacket)) {
            return false;
        }
        ClientboundChangeDifficultyPacket other = (ClientboundChangeDifficultyPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDifficultyLocked() != other.isDifficultyLocked()) {
            return false;
        }
        Difficulty this$difficulty = this.getDifficulty();
        Difficulty other$difficulty = other.getDifficulty();
        return !(this$difficulty == null ? other$difficulty != null : !((Object)((Object)this$difficulty)).equals((Object)other$difficulty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundChangeDifficultyPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDifficultyLocked() ? 79 : 97);
        Difficulty $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : ((Object)((Object)$difficulty)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundChangeDifficultyPacket(difficulty=" + (Object)((Object)this.getDifficulty()) + ", difficultyLocked=" + this.isDifficultyLocked() + ")";
    }

    public ClientboundChangeDifficultyPacket withDifficulty(@NonNull Difficulty difficulty) {
        if (difficulty == null) {
            throw new NullPointerException("difficulty is marked non-null but is null");
        }
        return this.difficulty == difficulty ? this : new ClientboundChangeDifficultyPacket(difficulty, this.difficultyLocked);
    }

    public ClientboundChangeDifficultyPacket withDifficultyLocked(boolean difficultyLocked) {
        return this.difficultyLocked == difficultyLocked ? this : new ClientboundChangeDifficultyPacket(this.difficulty, difficultyLocked);
    }

    public ClientboundChangeDifficultyPacket(@NonNull Difficulty difficulty, boolean difficultyLocked) {
        if (difficulty == null) {
            throw new NullPointerException("difficulty is marked non-null but is null");
        }
        this.difficulty = difficulty;
        this.difficultyLocked = difficultyLocked;
    }
}

