/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.chat;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class MessageSignature {
    private final int id;
    private final byte @Nullable [] messageSignature;

    public static MessageSignature read(ByteBuf in, MinecraftCodecHelper helper) {
        byte[] messageSignature;
        int id = helper.readVarInt(in) - 1;
        if (id == -1) {
            messageSignature = new byte[256];
            in.readBytes(messageSignature);
        } else {
            messageSignature = null;
        }
        return new MessageSignature(id, messageSignature);
    }

    public int getId() {
        return this.id;
    }

    public byte @Nullable [] getMessageSignature() {
        return this.messageSignature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageSignature)) {
            return false;
        }
        MessageSignature other = (MessageSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return Arrays.equals(this.getMessageSignature(), other.getMessageSignature());
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageSignature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + Arrays.hashCode(this.getMessageSignature());
        return result;
    }

    public String toString() {
        return "MessageSignature(id=" + this.getId() + ", messageSignature=" + this.getMessageSignature() + ")";
    }

    public MessageSignature(int id, byte @Nullable [] messageSignature) {
        this.id = id;
        this.messageSignature = messageSignature;
    }
}

