/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PermissionUtil;
import com.miguelbcr.ui.rx_paparazzo2.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import rx_activity_result2.OnPreResult;

public class PickFile
extends UseCase<Uri> {
    public static final String DEFAULT_MIME_TYPE = "*/*";
    private final Config config;
    private final StartIntent startIntent;
    private final TargetUi targetUi;

    public PickFile(TargetUi targetUi, Config config, StartIntent startIntent) {
        this.targetUi = targetUi;
        this.config = config;
        this.startIntent = startIntent;
    }

    public String getDefaultMimeType() {
        return DEFAULT_MIME_TYPE;
    }

    @Override
    public Observable<Uri> react() {
        return this.startIntent.with(this.getFileChooserIntent(), this.getOnPreResultProcessing()).react().map((Function)new Function<Intent, Uri>(){

            public Uri apply(Intent intent) throws Exception {
                return intent.getData();
            }
        });
    }

    private Intent getFileChooserIntent() {
        String mimeType = this.config.getMimeType(this.getDefaultMimeType());
        Intent intent = new Intent();
        intent.setType(mimeType);
        if (this.config.isUseDocumentPicker() && Build.VERSION.SDK_INT >= 19) {
            intent.setAction("android.intent.action.OPEN_DOCUMENT");
        } else {
            intent.setAction("android.intent.action.GET_CONTENT");
        }
        if (this.config.isPickOpenableOnly()) {
            intent.addCategory("android.intent.category.OPENABLE");
        }
        return intent;
    }

    private OnPreResult getOnPreResultProcessing() {
        return new OnPreResult(){

            public Observable<Uri> response(int requestCode, int resultCode, @Nullable Intent intent) {
                if (resultCode == -1 && intent != null && intent.getData() != null) {
                    Uri pickedUri = intent.getData();
                    PermissionUtil.grantReadPermissionToUri(PickFile.this.targetUi, pickedUri);
                    return Observable.just((Object)intent.getData());
                }
                return Observable.empty();
            }
        };
    }
}

