/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo.interactors;

import android.content.ClipData;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import com.miguelbcr.ui.rx_paparazzo.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo.interactors.GetPath;
import com.miguelbcr.ui.rx_paparazzo.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo.interactors.UseCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public final class PickImages
extends UseCase<List<Uri>> {
    private static final int READ_WRITE_PERMISSIONS = 3;
    private final StartIntent startIntent;
    private final GetPath getPath;
    private TargetUi targetUi;

    public PickImages(StartIntent startIntent, GetPath getPath, TargetUi targetUi) {
        this.startIntent = startIntent;
        this.getPath = getPath;
        this.targetUi = targetUi;
    }

    @Override
    public Observable<List<Uri>> react() {
        return this.startIntent.with(this.getFileChooserIntent()).react().map((Func1)new Func1<Intent, List<Uri>>(){

            public List<Uri> call(Intent intent) {
                if (intent == null) {
                    return new ArrayList<Uri>();
                }
                intent.addFlags(3);
                Uri pickedUri = intent.getData();
                if (pickedUri != null) {
                    PickImages.this.grantReadPermissionToUri(PickImages.this.targetUi, pickedUri);
                    return Arrays.asList(pickedUri);
                }
                return PickImages.this.getUris(intent);
            }
        });
    }

    private List<Uri> getUris(Intent intent) {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        ClipData clipData = intent.getClipData();
        if (clipData != null) {
            for (int i = 0; i < clipData.getItemCount(); ++i) {
                ClipData.Item item = clipData.getItemAt(i);
                Uri uri = item.getUri();
                this.grantReadPermissionToUri(this.targetUi, uri);
                uris.add(uri);
            }
        }
        return uris;
    }

    private Intent getFileChooserIntent() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        if (Build.VERSION.SDK_INT >= 18) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        return intent;
    }

    private void grantReadPermissionToUri(TargetUi targetUi, Uri uri) {
        String uiPackageName = targetUi.getContext().getPackageName();
        targetUi.getContext().grantUriPermission(uiPackageName, uri, 1);
    }
}

