/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.workers;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.Ignore;
import com.miguelbcr.ui.rx_paparazzo2.entities.Response;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.CropImage;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GrantPermissions;
import com.miguelbcr.ui.rx_paparazzo2.interactors.SaveImage;
import com.miguelbcr.ui.rx_paparazzo2.interactors.TakePhoto;
import com.miguelbcr.ui.rx_paparazzo2.workers.Worker;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;

public final class Camera
extends Worker {
    private final TakePhoto takePhoto;
    private final CropImage cropImage;
    private final SaveImage saveImage;
    private final GrantPermissions grantPermissions;
    private final TargetUi targetUi;
    private final Config config;

    public Camera(TakePhoto takePhoto, CropImage cropImage, SaveImage saveImage, GrantPermissions grantPermissions, TargetUi targetUi, Config config) {
        super(targetUi);
        this.takePhoto = takePhoto;
        this.cropImage = cropImage;
        this.saveImage = saveImage;
        this.grantPermissions = grantPermissions;
        this.targetUi = targetUi;
        this.config = config;
    }

    public <T> Observable<Response<T, String>> takePhoto() {
        return this.grantPermissions.with(this.permissions()).react().flatMap((Function)new Function<Ignore, ObservableSource<Uri>>(){

            public ObservableSource<Uri> apply(Ignore ignore) throws Exception {
                return Camera.this.takePhoto.react();
            }
        }).flatMap((Function)new Function<Uri, ObservableSource<Uri>>(){

            public ObservableSource<Uri> apply(Uri uri) throws Exception {
                return Camera.this.cropImage.with(uri).react();
            }
        }).flatMap((Function)new Function<Uri, ObservableSource<String>>(){

            public ObservableSource<String> apply(Uri uri) throws Exception {
                return Camera.this.saveImage.with(uri).react();
            }
        }).map(new Function<String, Response<T, String>>(){

            public Response<T, String> apply(String path) throws Exception {
                return new Response<Object, String>(Camera.this.targetUi.ui(), path, -1);
            }
        }).compose(this.applyOnError());
    }

    private String[] permissions() {
        if (this.config.useInternalStorage()) {
            if (this.hasCameraPermissionInManifest()) {
                return new String[]{"android.permission.CAMERA"};
            }
            return new String[0];
        }
        if (this.hasCameraPermissionInManifest()) {
            return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        }
        return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
    }

    private boolean hasCameraPermissionInManifest() {
        String packageName = this.targetUi.getContext().getPackageName();
        try {
            PackageInfo packageInfo = this.targetUi.getContext().getPackageManager().getPackageInfo(packageName, 4096);
            String[] declaredPermissions = packageInfo.requestedPermissions;
            if (declaredPermissions != null && declaredPermissions.length > 0) {
                for (String p : declaredPermissions) {
                    if (!p.equals("android.permission.CAMERA")) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

