/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo.workers;

import com.miguelbcr.ui.rx_paparazzo.entities.PermissionDeniedException;
import com.miguelbcr.ui.rx_paparazzo.entities.Response;
import com.miguelbcr.ui.rx_paparazzo.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo.entities.UserCanceledException;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

abstract class Worker {
    private final TargetUi targetUi;

    public Worker(TargetUi targetUi) {
        this.targetUi = targetUi;
    }

    protected <T> Observable.Transformer<T, T> applyOnError() {
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> observable) {
                return observable.onErrorResumeNext(new Func1<Throwable, Observable<? extends T>>(){

                    public Observable<? extends T> call(Throwable throwable) {
                        if (throwable instanceof UserCanceledException) {
                            return Observable.just(new Response<Object, Object>(Worker.this.targetUi.ui(), null, 0));
                        }
                        if (throwable instanceof PermissionDeniedException) {
                            return Observable.just(new Response<Object, Object>(Worker.this.targetUi.ui(), null, ((PermissionDeniedException)throwable).getCode()));
                        }
                        throw Exceptions.propagate((Throwable)throwable);
                    }
                });
            }
        };
    }
}

