/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo.interactors;

import com.miguelbcr.ui.rx_paparazzo.entities.PermissionDeniedException;
import com.miguelbcr.ui.rx_paparazzo.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo.interactors.UseCase;
import com.tbruyelle.rxpermissions.Permission;
import com.tbruyelle.rxpermissions.RxPermissions;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public final class GrantPermissions
extends UseCase<Void> {
    private final TargetUi targetUi;
    private String[] permissions;

    public GrantPermissions(TargetUi targetUi) {
        this.targetUi = targetUi;
    }

    public GrantPermissions with(String ... permissions) {
        this.permissions = permissions;
        return this;
    }

    @Override
    public Observable<Void> react() {
        if (this.permissions.length == 0) {
            return Observable.just(null);
        }
        return new RxPermissions(this.targetUi.activity()).requestEach(this.permissions).buffer(this.permissions.length).flatMapIterable((Func1)new Func1<List<Permission>, Iterable<Permission>>(){

            public Iterable<Permission> call(List<Permission> permissions) {
                return permissions;
            }
        }).flatMap((Func1)new Func1<Permission, Observable<Integer>>(){

            public Observable<Integer> call(Permission permission2) {
                if (permission2.granted) {
                    return Observable.just((Object)-1);
                }
                if (permission2.shouldShowRequestPermissionRationale) {
                    return Observable.just((Object)2);
                }
                return Observable.just((Object)3);
            }
        }).toList().flatMap((Func1)new Func1<List<Integer>, Observable<Void>>(){

            public Observable<Void> call(List<Integer> resultCodes) {
                int maxResultCode = -1;
                for (int resultCode : resultCodes) {
                    if (resultCode <= maxResultCode) continue;
                    maxResultCode = resultCode;
                }
                if (maxResultCode == -1) {
                    return Observable.just(null);
                }
                return Observable.error((Throwable)new PermissionDeniedException(maxResultCode));
            }
        });
    }
}

