/*
 * Decompiled with CFR 0.152.
 */
package com.fuck_boilerplate.rx_paparazzo.interactors;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import com.fuck_boilerplate.rx_paparazzo.entities.TargetUi;
import com.fuck_boilerplate.rx_paparazzo.interactors.DownloadImage;
import com.fuck_boilerplate.rx_paparazzo.interactors.UseCase;
import rx.Observable;
import rx.exceptions.Exceptions;

public final class GetPath
extends UseCase<String> {
    private final TargetUi targetUi;
    private final DownloadImage downloadImage;
    private Uri uri;

    public GetPath(TargetUi targetUi, DownloadImage downloadImage) {
        this.targetUi = targetUi;
        this.downloadImage = downloadImage;
    }

    public GetPath with(Uri uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Observable<String> react() {
        return this.getPath();
    }

    @SuppressLint(value={"NewApi"})
    private Observable<String> getPath() {
        boolean isKitKat = Build.VERSION.SDK_INT >= 19;
        Activity context = this.targetUi.activity();
        String filePath = null;
        if (this.uri == null) {
            return null;
        }
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)this.uri)) {
            if (this.isExternalStorageDocument(this.uri)) {
                Document document = this.getDocument(this.uri);
                if ("primary".equalsIgnoreCase(document.type)) {
                    filePath = Environment.getExternalStorageDirectory() + "/" + document.id;
                }
            } else if (this.isDownloadsDocument(this.uri)) {
                String id = DocumentsContract.getDocumentId((Uri)this.uri);
                Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                filePath = this.getDataColumn((Context)context, contentUri, null, null);
            } else if (this.isMediaDocument(this.uri)) {
                Document document = this.getDocument(this.uri);
                Uri contentUri = null;
                if ("image".equals(document.type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(document.type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(document.type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                filePath = this.getDataColumn((Context)context, contentUri, "_id=?", new String[]{document.id});
            }
        } else if ("content".equalsIgnoreCase(this.uri.getScheme())) {
            filePath = this.getDataColumn((Context)context, this.uri, null, null);
        } else if ("file".equalsIgnoreCase(this.uri.getScheme())) {
            filePath = this.uri.getPath();
        }
        if (filePath == null) {
            return this.downloadImage.with(this.uri).react();
        }
        return Observable.just((Object)filePath);
    }

    @SuppressLint(value={"NewApi"})
    private Document getDocument(Uri uri) {
        Document document = new Document();
        String docId = DocumentsContract.getDocumentId((Uri)uri);
        String[] docArray = docId.split(":");
        document.type = docArray[0];
        document.id = docArray[1];
        return document;
    }

    private String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{column};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            cursor.moveToFirst();
            String string = cursor.getString(cursor.getColumnIndexOrThrow(column));
            return string;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private class Document {
        String type;
        String id;

        private Document() {
        }
    }
}

