/*
 * Decompiled with CFR 0.152.
 */
package com.fuck_boilerplate.rx_paparazzo.workers;

import android.net.Uri;
import com.fuck_boilerplate.rx_paparazzo.entities.Config;
import com.fuck_boilerplate.rx_paparazzo.entities.Response;
import com.fuck_boilerplate.rx_paparazzo.entities.TargetUi;
import com.fuck_boilerplate.rx_paparazzo.interactors.CropImage;
import com.fuck_boilerplate.rx_paparazzo.interactors.GrantPermissions;
import com.fuck_boilerplate.rx_paparazzo.interactors.PickImage;
import com.fuck_boilerplate.rx_paparazzo.interactors.PickImages;
import com.fuck_boilerplate.rx_paparazzo.interactors.SaveImage;
import com.fuck_boilerplate.rx_paparazzo.workers.Worker;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public final class Gallery
extends Worker {
    private final GrantPermissions grantPermissions;
    private final PickImages pickImages;
    private final PickImage pickImage;
    private final CropImage cropImage;
    private final SaveImage saveImage;
    private final TargetUi targetUi;
    private final Config config;

    public Gallery(GrantPermissions grantPermissions, PickImages pickImages, PickImage pickImage, CropImage cropImage, SaveImage saveImage, TargetUi targetUi, Config config) {
        super(targetUi);
        this.grantPermissions = grantPermissions;
        this.pickImages = pickImages;
        this.pickImage = pickImage;
        this.cropImage = cropImage;
        this.saveImage = saveImage;
        this.targetUi = targetUi;
        this.config = config;
    }

    public <T> Observable<Response<T, String>> pickImage() {
        return this.grantPermissions.with(this.permissions()).react().flatMap((Func1)new Func1<Void, Observable<Uri>>(){

            public Observable<Uri> call(Void granted) {
                return Gallery.this.pickImage.react();
            }
        }).flatMap((Func1)new Func1<Uri, Observable<Uri>>(){

            public Observable<Uri> call(Uri uri) {
                return Gallery.this.cropImage.with(uri).react();
            }
        }).flatMap((Func1)new Func1<Uri, Observable<String>>(){

            public Observable<String> call(Uri uri) {
                return Gallery.this.saveImage.with(uri).react();
            }
        }).map(new Func1<String, Response<T, String>>(){

            public Response<T, String> call(String path) {
                return new Response<Object, String>(Gallery.this.targetUi.ui(), path, -1);
            }
        }).compose(this.applyOnError());
    }

    public <T> Observable<Response<T, List<String>>> pickImages() {
        return this.grantPermissions.with(this.permissions()).react().flatMap((Func1)new Func1<Void, Observable<List<Uri>>>(){

            public Observable<List<Uri>> call(Void granted) {
                return Gallery.this.pickImages.react();
            }
        }).flatMapIterable((Func1)new Func1<List<Uri>, Iterable<Uri>>(){

            public Iterable<Uri> call(List<Uri> uris) {
                return uris;
            }
        }).concatMap((Func1)new Func1<Uri, Observable<Uri>>(){

            public Observable<Uri> call(Uri uri) {
                return Gallery.this.cropImage.with(uri).react();
            }
        }).concatMap((Func1)new Func1<Uri, Observable<String>>(){

            public Observable<String> call(Uri uri) {
                return Gallery.this.saveImage.with(uri).react();
            }
        }).toList().map(new Func1<List<String>, Response<T, List<String>>>(){

            public Response<T, List<String>> call(List<String> paths) {
                return new Response<Object, List<String>>(Gallery.this.targetUi.ui(), paths, -1);
            }
        }).compose(this.applyOnError());
    }

    private String[] permissions() {
        if (this.config.useInternalStorage()) {
            return new String[0];
        }
        return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
    }
}

