/*
 * Decompiled with CFR 0.152.
 */
package com.fuck_boilerplate.rx_paparazzo.workers;

import android.net.Uri;
import com.fuck_boilerplate.rx_paparazzo.entities.Response;
import com.fuck_boilerplate.rx_paparazzo.entities.TargetUi;
import com.fuck_boilerplate.rx_paparazzo.interactors.CropImage;
import com.fuck_boilerplate.rx_paparazzo.interactors.GrantPermissions;
import com.fuck_boilerplate.rx_paparazzo.interactors.SaveImage;
import com.fuck_boilerplate.rx_paparazzo.interactors.TakePhoto;
import com.fuck_boilerplate.rx_paparazzo.workers.Worker;
import rx.Observable;
import rx.functions.Func1;

public final class Camera
extends Worker {
    private final TakePhoto takePhoto;
    private final CropImage cropImage;
    private final SaveImage saveImage;
    private final GrantPermissions grantPermissions;
    private final TargetUi targetUi;

    public Camera(TakePhoto takePhoto, CropImage cropImage, SaveImage saveImage, GrantPermissions grantPermissions, TargetUi targetUi) {
        super(targetUi);
        this.takePhoto = takePhoto;
        this.cropImage = cropImage;
        this.saveImage = saveImage;
        this.grantPermissions = grantPermissions;
        this.targetUi = targetUi;
    }

    public <T> Observable<Response<T, String>> takePhoto() {
        String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.CAMERA"};
        return this.grantPermissions.with(permissions).react().flatMap((Func1)new Func1<Void, Observable<Uri>>(){

            public Observable<Uri> call(Void granted) {
                return Camera.this.takePhoto.react();
            }
        }).flatMap((Func1)new Func1<Uri, Observable<Uri>>(){

            public Observable<Uri> call(Uri uri) {
                return Camera.this.cropImage.with(uri).react();
            }
        }).flatMap((Func1)new Func1<Uri, Observable<String>>(){

            public Observable<String> call(Uri uri) {
                return Camera.this.saveImage.with(uri).react();
            }
        }).map(new Func1<String, Response<T, String>>(){

            public Response<T, String> call(String path) {
                return new Response<Object, String>(Camera.this.targetUi.ui(), path, -1);
            }
        }).compose(this.applyOnError());
    }
}

