/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.player;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lavalink.client.LavalinkUtil;
import lavalink.client.io.LavalinkSocket;
import lavalink.client.io.Link;
import lavalink.client.player.IPlayer;
import lavalink.client.player.LavalinkInternalPlayerEventHandler;
import lavalink.client.player.TrackData;
import lavalink.client.player.event.IPlayerEventListener;
import lavalink.client.player.event.PlayerEvent;
import lavalink.client.player.event.PlayerPauseEvent;
import lavalink.client.player.event.PlayerResumeEvent;
import lavalink.client.player.event.TrackStartEvent;
import org.json.JSONObject;

public class LavalinkPlayer
implements IPlayer {
    private AudioTrack track = null;
    private boolean paused = false;
    private int volume = 100;
    private long updateTime = -1L;
    private long position = -1L;
    private final Link link;
    private List<IPlayerEventListener> listeners = new CopyOnWriteArrayList<IPlayerEventListener>();

    public LavalinkPlayer(Link link) {
        this.link = link;
        this.addListener(new LavalinkInternalPlayerEventHandler());
    }

    public void onNodeChange() {
        AudioTrack track = this.getPlayingTrack();
        if (track != null) {
            track.setPosition(this.getTrackPosition());
            this.playTrack(track);
        }
    }

    @Override
    public AudioTrack getPlayingTrack() {
        return this.track;
    }

    @Override
    public void playTrack(AudioTrack track) {
        try {
            this.position = track.getPosition();
            TrackData trackData = (TrackData)track.getUserData(TrackData.class);
            JSONObject json = new JSONObject();
            json.put("op", (Object)"play");
            json.put("guildId", (Object)this.link.getGuildId());
            json.put("track", (Object)LavalinkUtil.toMessage(track));
            json.put("startTime", this.position);
            if (trackData != null) {
                json.put("startTime", trackData.startPos);
                json.put("endTime", trackData.endPos);
            }
            json.put("pause", this.paused);
            json.put("volume", this.volume);
            this.link.getNode(true).send(json.toString());
            this.updateTime = System.currentTimeMillis();
            this.track = track;
            this.emitEvent(new TrackStartEvent(this, track));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stopTrack() {
        this.track = null;
        LavalinkSocket node = this.link.getNode(false);
        if (node == null) {
            return;
        }
        JSONObject json = new JSONObject();
        json.put("op", (Object)"stop");
        json.put("guildId", (Object)this.link.getGuildId());
        node.send(json.toString());
    }

    @Override
    public void setPaused(boolean pause) {
        if (pause == this.paused) {
            return;
        }
        LavalinkSocket node = this.link.getNode(false);
        if (node != null) {
            JSONObject json = new JSONObject();
            json.put("op", (Object)"pause");
            json.put("guildId", (Object)this.link.getGuildId());
            json.put("pause", pause);
            node.send(json.toString());
        }
        this.paused = pause;
        if (pause) {
            this.emitEvent(new PlayerPauseEvent(this));
        } else {
            this.emitEvent(new PlayerResumeEvent(this));
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public long getTrackPosition() {
        if (this.getPlayingTrack() == null) {
            throw new IllegalStateException("Not currently playing anything");
        }
        if (!this.paused) {
            long timeDiff = System.currentTimeMillis() - this.updateTime;
            return Math.min(this.position + timeDiff, this.track.getDuration());
        }
        return Math.min(this.position, this.track.getDuration());
    }

    @Override
    public void seekTo(long position) {
        if (this.getPlayingTrack() == null) {
            throw new IllegalStateException("Not currently playing anything");
        }
        if (!this.getPlayingTrack().isSeekable()) {
            throw new IllegalStateException("Track cannot be seeked");
        }
        JSONObject json = new JSONObject();
        json.put("op", (Object)"seek");
        json.put("guildId", (Object)this.link.getGuildId());
        json.put("position", position);
        this.link.getNode(true).send(json.toString());
    }

    @Override
    public void setVolume(int volume) {
        this.volume = volume = Math.min(1000, Math.max(0, volume));
        LavalinkSocket node = this.link.getNode(false);
        if (node == null) {
            return;
        }
        JSONObject json = new JSONObject();
        json.put("op", (Object)"volume");
        json.put("guildId", (Object)this.link.getGuildId());
        json.put("volume", volume);
        node.send(json.toString());
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    public void provideState(JSONObject json) {
        this.updateTime = json.getLong("time");
        this.position = json.optLong("position", 0L);
    }

    @Override
    public void addListener(IPlayerEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IPlayerEventListener listener) {
        this.listeners.remove(listener);
    }

    public void emitEvent(PlayerEvent event) {
        this.listeners.forEach(listener -> listener.onEvent(event));
    }

    void clearTrack() {
        this.track = null;
    }

    public Link getLink() {
        return this.link;
    }
}

