/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io.metrics;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lavalink.client.io.Lavalink;
import lavalink.client.io.LavalinkSocket;
import lavalink.client.io.RemoteStats;

public class LavalinkCollector
extends Collector {
    private final Lavalink lavalink;

    public LavalinkCollector(@NonNull Lavalink lavalinkInstance) {
        this.lavalink = lavalinkInstance;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        List<String> labelNames = Collections.singletonList("node");
        GaugeMetricFamily players = new GaugeMetricFamily("lavalink_players_current", "Amount of players", labelNames);
        mfs.add((Collector.MetricFamilySamples)players);
        GaugeMetricFamily playingPlayers = new GaugeMetricFamily("lavalink_playing_players_current", "Amount of playing players", labelNames);
        mfs.add((Collector.MetricFamilySamples)playingPlayers);
        GaugeMetricFamily uptimeSeconds = new GaugeMetricFamily("lavalink_uptime_seconds", "Uptime of the node", labelNames);
        mfs.add((Collector.MetricFamilySamples)uptimeSeconds);
        GaugeMetricFamily memFree = new GaugeMetricFamily("lavalink_mem_free_bytes", "Amount of free memory", labelNames);
        mfs.add((Collector.MetricFamilySamples)memFree);
        GaugeMetricFamily memUsed = new GaugeMetricFamily("lavalink_mem_used_bytes", "Amount of used memory", labelNames);
        mfs.add((Collector.MetricFamilySamples)memUsed);
        GaugeMetricFamily memAllocated = new GaugeMetricFamily("lavalink_mem_allocated_bytes", "Amount of allocated memory", labelNames);
        mfs.add((Collector.MetricFamilySamples)memAllocated);
        GaugeMetricFamily memReservable = new GaugeMetricFamily("lavalink_mem_reservable_bytes", "Amount of reservable memory", labelNames);
        mfs.add((Collector.MetricFamilySamples)memReservable);
        GaugeMetricFamily cpuCores = new GaugeMetricFamily("lavalink_cpu_cores", "Amount of cpu cores", labelNames);
        mfs.add((Collector.MetricFamilySamples)cpuCores);
        GaugeMetricFamily systemLoad = new GaugeMetricFamily("lavalink_load_system", "Total load of the system", labelNames);
        mfs.add((Collector.MetricFamilySamples)systemLoad);
        GaugeMetricFamily lavalinkLoad = new GaugeMetricFamily("lavalink_load_lavalink", "Load caused by Lavalink", labelNames);
        mfs.add((Collector.MetricFamilySamples)lavalinkLoad);
        GaugeMetricFamily averageFramesSentPerMinute = new GaugeMetricFamily("lavalink_average_frames_sent_per_minute", "Average frames sent per minute", labelNames);
        mfs.add((Collector.MetricFamilySamples)averageFramesSentPerMinute);
        GaugeMetricFamily averageFramesNulledPerMinute = new GaugeMetricFamily("lavalink_average_frames_nulled_per_minute", "Average frames nulled per minute", labelNames);
        mfs.add((Collector.MetricFamilySamples)averageFramesNulledPerMinute);
        GaugeMetricFamily averageFramesDeficitPerMinute = new GaugeMetricFamily("lavalink_average_frames_deficit_per_minute", "Average frames deficit per minute", labelNames);
        mfs.add((Collector.MetricFamilySamples)averageFramesDeficitPerMinute);
        List<LavalinkSocket> nodes = this.lavalink.getNodes();
        for (LavalinkSocket node : nodes) {
            List<String> labels = Collections.singletonList(node.getName());
            RemoteStats stats = node.getStats();
            if (stats == null) continue;
            players.addMetric(labels, (double)stats.getPlayers());
            playingPlayers.addMetric(labels, (double)stats.getPlayingPlayers());
            uptimeSeconds.addMetric(labels, (double)(stats.getUptime() / 1000L));
            memFree.addMetric(labels, (double)stats.getMemFree());
            memUsed.addMetric(labels, (double)stats.getMemUsed());
            memAllocated.addMetric(labels, (double)stats.getMemAllocated());
            memReservable.addMetric(labels, (double)stats.getMemReservable());
            cpuCores.addMetric(labels, (double)stats.getCpuCores());
            systemLoad.addMetric(labels, stats.getSystemLoad());
            lavalinkLoad.addMetric(labels, stats.getLavalinkLoad());
            averageFramesSentPerMinute.addMetric(labels, (double)stats.getAvgFramesSentPerMinute());
            averageFramesNulledPerMinute.addMetric(labels, (double)stats.getAvgFramesNulledPerMinute());
            averageFramesDeficitPerMinute.addMetric(labels, (double)stats.getAvgFramesDeficitPerMinute());
        }
        return mfs;
    }
}

