/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io.jda;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lavalink.client.io.Link;
import lavalink.client.io.jda.JdaLavalink;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.exceptions.GuildUnavailableException;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdaLink
extends Link {
    private static final Logger log = LoggerFactory.getLogger(JdaLink.class);
    private final JdaLavalink lavalink;

    JdaLink(JdaLavalink lavalink, String guildId) {
        super(lavalink, guildId);
        this.lavalink = lavalink;
    }

    public void connect(VoiceChannel voiceChannel) {
        this.connect(voiceChannel, true);
    }

    void connect(VoiceChannel channel, boolean checkChannel) {
        if (!channel.getGuild().equals(this.getJda().getGuildById(this.guild))) {
            throw new IllegalArgumentException("The provided VoiceChannel is not a part of the Guild that this AudioManager handles.Please provide a VoiceChannel from the proper Guild");
        }
        if (!channel.getGuild().isAvailable()) {
            throw new GuildUnavailableException("Cannot open an Audio Connection with an unavailable guild. Please wait until this Guild is available to open a connection.");
        }
        Member self = channel.getGuild().getSelfMember();
        if (!self.hasPermission((GuildChannel)channel, new Permission[]{Permission.VOICE_CONNECT}) && !self.hasPermission((GuildChannel)channel, new Permission[]{Permission.VOICE_MOVE_OTHERS})) {
            throw new InsufficientPermissionException((GuildChannel)channel, Permission.VOICE_CONNECT);
        }
        if (checkChannel && channel.equals(channel.getGuild().getSelfMember().getVoiceState().getChannel())) {
            return;
        }
        if (channel.getGuild().getSelfMember().getVoiceState().inVoiceChannel()) {
            int userLimit = channel.getUserLimit();
            if (!(self.isOwner() || self.hasPermission(new Permission[]{Permission.ADMINISTRATOR}) || userLimit <= 0 || userLimit > channel.getMembers().size() || self.hasPermission((GuildChannel)channel, new Permission[]{Permission.VOICE_MOVE_OTHERS}))) {
                throw new InsufficientPermissionException((GuildChannel)channel, Permission.VOICE_MOVE_OTHERS, "Unable to connect to VoiceChannel due to userlimit! Requires permission VOICE_MOVE_OTHERS to bypass");
            }
        }
        this.setState(Link.State.CONNECTING);
        this.queueAudioConnect(channel.getIdLong());
    }

    @Nonnull
    public JDA getJda() {
        return this.lavalink.getJdaFromSnowflake(String.valueOf(this.guild));
    }

    @Override
    protected void removeConnection() {
    }

    @Override
    protected void queueAudioDisconnect() {
        Guild g = this.getJda().getGuildById(this.guild);
        if (g != null) {
            this.getJda().getDirectAudioController().disconnect(g);
        } else {
            log.warn("Attempted to disconnect, but guild {} was not found", (Object)this.guild);
        }
    }

    @Override
    protected void queueAudioConnect(long channelId) {
        VoiceChannel vc = this.getJda().getVoiceChannelById(channelId);
        if (vc != null) {
            this.getJda().getDirectAudioController().connect(vc);
        } else {
            log.warn("Attempted to connect, but voice channel {} was not found", (Object)channelId);
        }
    }

    @Nullable
    public Guild getGuild() {
        return this.getJda().getGuildById(this.guild);
    }
}

