/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReusableWebSocket {
    private static final Logger log = LoggerFactory.getLogger(ReusableWebSocket.class);
    private DisposableSocket socket;
    private final URI serverUri;
    private final Draft draft;
    private final Map<String, String> headers;
    private final int connectTimeout;
    private final ReusableWebSocket instance = this;
    private boolean isUsed = false;

    public ReusableWebSocket(URI serverUri, Draft draft, Map<String, String> headers, int connectTimeout) {
        this.serverUri = serverUri;
        this.draft = draft;
        this.headers = headers;
        this.connectTimeout = connectTimeout;
    }

    public abstract void onOpen(ServerHandshake var1);

    public abstract void onMessage(String var1);

    public abstract void onClose(int var1, String var2, boolean var3);

    public abstract void onError(Exception var1);

    public void send(String text) {
        if (this.socket != null && this.socket.isOpen()) {
            this.socket.send(text);
        }
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public boolean isOpen() {
        return this.socket != null && this.socket.isOpen();
    }

    public boolean isConnecting() {
        return this.socket != null && this.socket.isConnecting();
    }

    public boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public boolean isClosing() {
        return this.socket != null && this.socket.isClosing();
    }

    public void connect() {
        if (this.socket == null || this.isUsed) {
            this.socket = new DisposableSocket(this.serverUri, this.draft, this.headers, this.connectTimeout);
        }
        this.socket.connect();
        this.isUsed = true;
    }

    public void connectBlocking() throws InterruptedException {
        if (this.socket == null || this.isUsed) {
            this.socket = new DisposableSocket(this.serverUri, this.draft, this.headers, this.connectTimeout);
        }
        this.socket.connectBlocking();
        this.isUsed = true;
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void close(int code) {
        if (this.socket != null) {
            this.socket.close(code);
        }
    }

    public void close(int code, String reason) {
        if (this.socket != null) {
            this.socket.close(code, reason);
        }
    }

    private class DisposableSocket
    extends WebSocketClient {
        DisposableSocket(URI serverUri, Draft protocolDraft, Map<String, String> httpHeaders, int connectTimeout) {
            super(serverUri, protocolDraft, httpHeaders, connectTimeout);
            ReusableWebSocket.this.isUsed = false;
        }

        public void onOpen(ServerHandshake handshakedata) {
            ReusableWebSocket.this.instance.onOpen(handshakedata);
        }

        public void onMessage(String message) {
            ReusableWebSocket.this.instance.onMessage(message);
        }

        public void onClose(int code, String reason, boolean remote) {
            ReusableWebSocket.this.instance.onClose(code, reason, remote);
        }

        public void onError(Exception ex) {
            ReusableWebSocket.this.instance.onError(ex);
        }
    }
}

