/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import lavalink.client.io.Lavalink;
import lavalink.client.io.LavalinkSocket;
import lavalink.client.player.LavalinkPlayer;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Link {
    private static final Logger log = LoggerFactory.getLogger(Link.class);
    private JSONObject lastVoiceServerUpdate = null;
    private String lastSessionId = null;
    private final Lavalink lavalink;
    protected final long guild;
    private LavalinkPlayer player;
    private volatile String channel = null;
    private volatile LavalinkSocket node = null;
    private volatile State state = State.NOT_CONNECTED;

    protected Link(Lavalink lavalink, String guildId) {
        this.lavalink = lavalink;
        this.guild = Long.parseLong(guildId);
    }

    public LavalinkPlayer getPlayer() {
        if (this.player == null) {
            this.player = new LavalinkPlayer(this);
        }
        return this.player;
    }

    public Lavalink getLavalink() {
        return this.lavalink;
    }

    public void resetPlayer() {
        this.player = null;
    }

    public String getGuildId() {
        return Long.toString(this.guild);
    }

    public long getGuildIdLong() {
        return this.guild;
    }

    public void disconnect() {
        this.setState(State.DISCONNECTING);
        this.queueAudioDisconnect();
    }

    public void changeNode(LavalinkSocket newNode) {
        this.node = newNode;
        if (this.lastVoiceServerUpdate != null) {
            this.onVoiceServerUpdate(this.getLastVoiceServerUpdate(), this.lastSessionId);
            this.player.onNodeChange();
        }
    }

    public void onDisconnected() {
        this.setState(State.NOT_CONNECTED);
        LavalinkSocket socket = this.getNode(false);
        if (socket != null && this.state != State.DESTROYING && this.state != State.DESTROYED) {
            socket.send(new JSONObject().put("op", (Object)"destroy").put("guildId", (Object)Long.toString(this.guild)).toString());
            this.node = null;
        }
    }

    public void destroy() {
        boolean shouldDisconnect = this.state != State.DISCONNECTING && this.state != State.NOT_CONNECTED;
        this.setState(State.DESTROYING);
        if (shouldDisconnect) {
            try {
                this.queueAudioDisconnect();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.setState(State.DESTROYED);
        this.lavalink.removeDestroyedLink(this);
        LavalinkSocket socket = this.getNode(false);
        if (socket != null) {
            socket.send(new JSONObject().put("op", (Object)"destroy").put("guildId", (Object)Long.toString(this.guild)).toString());
        }
    }

    protected abstract void removeConnection();

    protected abstract void queueAudioDisconnect();

    protected abstract void queueAudioConnect(long var1);

    @Nullable
    public LavalinkSocket getNode() {
        return this.getNode(false);
    }

    @Nullable
    public LavalinkSocket getNode(boolean selectIfAbsent) {
        if (selectIfAbsent && this.node == null) {
            this.node = this.lavalink.loadBalancer.determineBestSocket(this.guild);
            if (this.player != null) {
                this.player.onNodeChange();
            }
        }
        return this.node;
    }

    @Nullable
    public String getChannel() {
        if (this.channel == null || this.state == State.DESTROYED || this.state == State.NOT_CONNECTED) {
            return null;
        }
        return this.channel;
    }

    @Nullable
    public String getLastChannel() {
        return this.channel;
    }

    public State getState() {
        return this.state;
    }

    public void setState(@NonNull State state) {
        if (this.state == State.DESTROYED && state != State.DESTROYED) {
            throw new IllegalStateException("Cannot change state to " + (Object)((Object)state) + " when state is " + (Object)((Object)State.DESTROYED));
        }
        if (this.state == State.DESTROYING && state != State.DESTROYED) {
            throw new IllegalStateException("Cannot change state to " + (Object)((Object)state) + " when state is " + (Object)((Object)State.DESTROYING));
        }
        log.debug("Link {} changed state from {} to {}", new Object[]{this, this.state, state});
        this.state = state;
    }

    public void setChannel(@NonNull String channel) {
        this.channel = channel;
    }

    public String toString() {
        return "Link{guild='" + this.guild + '\'' + ", channel='" + this.channel + '\'' + ", state=" + (Object)((Object)this.state) + '}';
    }

    public void onVoiceServerUpdate(JSONObject json, String sessionId) {
        this.lastVoiceServerUpdate = json;
        this.lastSessionId = sessionId;
        JSONObject out = new JSONObject();
        out.put("op", (Object)"voiceUpdate");
        out.put("sessionId", (Object)sessionId);
        out.put("guildId", (Object)Long.toString(this.guild));
        out.put("event", (Object)this.lastVoiceServerUpdate);
        this.getNode(true).send(out.toString());
        this.setState(State.CONNECTED);
    }

    public JSONObject getLastVoiceServerUpdate() {
        return this.lastVoiceServerUpdate;
    }

    public void onVoiceWebSocketClosed(int code, String reason, boolean byRemote) {
    }

    public static enum State {
        NOT_CONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING,
        DESTROYING,
        DESTROYED;

    }
}

