/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client.io;

import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.nio.channels.NotYetConnectedException;
import java.util.Map;
import java.util.Objects;
import lavalink.client.LavalinkUtil;
import lavalink.client.io.Lavalink;
import lavalink.client.io.Link;
import lavalink.client.io.RemoteStats;
import lavalink.client.io.RemoteTrackException;
import lavalink.client.io.ReusableWebSocket;
import lavalink.client.player.LavalinkPlayer;
import lavalink.client.player.event.PlayerEvent;
import lavalink.client.player.event.TrackEndEvent;
import lavalink.client.player.event.TrackExceptionEvent;
import lavalink.client.player.event.TrackStuckEvent;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LavalinkSocket
extends ReusableWebSocket {
    private static final Logger log = LoggerFactory.getLogger(LavalinkSocket.class);
    private static final int TIMEOUT_MS = 5000;
    @NonNull
    private final String name;
    @NonNull
    private final Lavalink lavalink;
    @Nullable
    private RemoteStats stats;
    long lastReconnectAttempt = 0L;
    private int reconnectsAttempted = 0;
    @NonNull
    private final URI remoteUri;
    private boolean available = false;

    LavalinkSocket(@NonNull String name, @NonNull Lavalink lavalink, @NonNull URI serverUri, Draft protocolDraft, Map<String, String> headers) {
        super(serverUri, protocolDraft, headers, 5000);
        this.name = name;
        this.lavalink = lavalink;
        this.remoteUri = serverUri;
    }

    @Override
    public void onOpen(ServerHandshake handshakeData) {
        log.info("Received handshake from server");
        this.available = true;
        this.lavalink.loadBalancer.onNodeConnect(this);
        this.reconnectsAttempted = 0;
    }

    @Override
    public void onMessage(String message) {
        JSONObject json = new JSONObject(message);
        if (!Objects.equals(json.getString("op"), "playerUpdate")) {
            log.debug(message);
        }
        switch (json.getString("op")) {
            case "playerUpdate": {
                ((Link)this.lavalink.getLink(json.getString("guildId"))).getPlayer().provideState(json.getJSONObject("state"));
                break;
            }
            case "stats": {
                this.stats = new RemoteStats(json);
                break;
            }
            case "event": {
                try {
                    this.handleEvent(json);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                log.warn("Unexpected operation: " + json.getString("op"));
            }
        }
    }

    private void handleEvent(JSONObject json) throws IOException {
        Object link = this.lavalink.getLink(json.getString("guildId"));
        LavalinkPlayer player = ((Link)this.lavalink.getLink(json.getString("guildId"))).getPlayer();
        PlayerEvent event = null;
        switch (json.getString("type")) {
            case "TrackEndEvent": {
                event = new TrackEndEvent(player, LavalinkUtil.toAudioTrack(json.getString("track")), AudioTrackEndReason.valueOf((String)json.getString("reason")));
                break;
            }
            case "TrackExceptionEvent": {
                RemoteTrackException ex;
                if (json.has("exception")) {
                    JSONObject jsonEx = json.getJSONObject("exception");
                    ex = new FriendlyException(jsonEx.getString("message"), FriendlyException.Severity.valueOf((String)jsonEx.getString("severity")), (Throwable)new RuntimeException(jsonEx.getString("cause")));
                } else {
                    ex = new RemoteTrackException(json.getString("error"));
                }
                event = new TrackExceptionEvent(player, LavalinkUtil.toAudioTrack(json.getString("track")), ex);
                break;
            }
            case "TrackStuckEvent": {
                event = new TrackStuckEvent(player, LavalinkUtil.toAudioTrack(json.getString("track")), json.getLong("thresholdMs"));
                break;
            }
            case "WebSocketClosedEvent": {
                ((Link)link).onVoiceWebSocketClosed(json.getInt("code"), json.getString("reason"), json.getBoolean("byRemote"));
                break;
            }
            default: {
                log.warn("Unexpected event type: " + json.getString("type"));
            }
        }
        if (event != null) {
            player.emitEvent(event);
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        this.available = false;
        String string = reason = reason == null ? "<no reason given>" : reason;
        if (code == 1000) {
            log.info("Connection to " + this.getRemoteUri() + " closed gracefully with reason: " + reason + " :: Remote=" + remote);
        } else {
            log.warn("Connection to " + this.getRemoteUri() + " closed unexpectedly with reason " + code + ": " + reason + " :: Remote=" + remote);
        }
        this.lavalink.loadBalancer.onNodeDisconnect(this);
    }

    @Override
    public void onError(Exception ex) {
        if (ex instanceof ConnectException) {
            log.warn("Failed to connect to " + this.getRemoteUri() + ", retrying in " + this.getReconnectInterval() / 1000L + " seconds.");
            return;
        }
        log.error("Caught exception in websocket", (Throwable)ex);
    }

    @Override
    public void send(String text) throws NotYetConnectedException {
        if (this.isOpen()) {
            super.send(text);
        } else if (this.isConnecting()) {
            log.warn("Attempting to send messages to " + this.getRemoteUri() + " WHILE connecting. Ignoring.");
        }
    }

    @NonNull
    public URI getRemoteUri() {
        return this.remoteUri;
    }

    void attemptReconnect() {
        this.lastReconnectAttempt = System.currentTimeMillis();
        ++this.reconnectsAttempted;
        this.connect();
    }

    long getReconnectInterval() {
        return this.reconnectsAttempted * 2000 - 2000;
    }

    @Nullable
    public RemoteStats getStats() {
        return this.stats;
    }

    public boolean isAvailable() {
        return this.available && this.isOpen() && !this.isClosing();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "LavalinkSocket{name=" + this.name + ",remoteUri=" + this.remoteUri + '}';
    }
}

