/*
 * Decompiled with CFR 0.152.
 */
package lavalink.client;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.bandcamp.BandcampAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageInput;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageOutput;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.java_websocket.util.Base64;

public class LavalinkUtil {
    private static final AudioPlayerManager PLAYER_MANAGER = new DefaultAudioPlayerManager();

    public static AudioTrack toAudioTrack(String message) throws IOException {
        return LavalinkUtil.toAudioTrack(Base64.decode((String)message));
    }

    public static AudioTrack toAudioTrack(byte[] message) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(message);
        return LavalinkUtil.PLAYER_MANAGER.decodeTrack((MessageInput)new MessageInput((InputStream)bais)).decodedTrack;
    }

    public static String toMessage(AudioTrack track) throws IOException {
        return Base64.encodeBytes((byte[])LavalinkUtil.toBinary(track));
    }

    public static byte[] toBinary(AudioTrack track) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PLAYER_MANAGER.encodeTrack(new MessageOutput((OutputStream)baos), track);
        return baos.toByteArray();
    }

    public static int getShardFromSnowflake(String snowflake, int numShards) {
        return (int)((Long.parseLong(snowflake) >> 22) % (long)numShards);
    }

    static {
        PLAYER_MANAGER.registerSourceManager((AudioSourceManager)new YoutubeAudioSourceManager());
        PLAYER_MANAGER.registerSourceManager((AudioSourceManager)new BandcampAudioSourceManager());
        PLAYER_MANAGER.registerSourceManager((AudioSourceManager)new SoundCloudAudioSourceManager());
        PLAYER_MANAGER.registerSourceManager((AudioSourceManager)new TwitchStreamAudioSourceManager());
        PLAYER_MANAGER.registerSourceManager((AudioSourceManager)new VimeoAudioSourceManager());
        PLAYER_MANAGER.registerSourceManager((AudioSourceManager)new HttpAudioSourceManager());
    }
}

