/*
 * Decompiled with CFR 0.152.
 */
package com.mediapermissionlib.byfoysaltechyt;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import com.mediapermissionlib.byfoysaltechyt.CustomAlertDialog;
import com.mediapermissionlib.byfoysaltechyt.DialogConfig;
import com.mediapermissionlib.byfoysaltechyt.FirstTimeStore;
import com.mediapermissionlib.byfoysaltechyt.PermissionCallback;
import java.util.ArrayList;
import java.util.List;

public class PermissionManager {
    public AppCompatActivity activity;
    private final PermissionCallback callback;
    private ActivityResultLauncher<String[]> requestPermissionLauncher;
    private CustomAlertDialog alertDialog;
    private FirstTimeStore firstTimeStore;
    private final boolean useFirstTimeStore;

    public PermissionManager(AppCompatActivity activity, PermissionCallback callback, boolean useFirstTimeStore) {
        this.activity = activity;
        this.callback = callback;
        this.useFirstTimeStore = useFirstTimeStore;
        if (useFirstTimeStore) {
            this.firstTimeStore = new FirstTimeStore((Context)activity);
        }
        this.initializeLauncher();
    }

    private void initializeLauncher() {
        this.requestPermissionLauncher = this.activity.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), result -> {
            boolean allGranted = true;
            for (Boolean granted : result.values()) {
                if (granted.booleanValue()) continue;
                allGranted = false;
                break;
            }
            if (allGranted) {
                if (this.useFirstTimeStore && this.firstTimeStore != null) {
                    this.firstTimeStore.storeFirstTime(1);
                }
                this.callback.onPermissionGranted();
            } else {
                this.callback.onPermissionDenied();
            }
        });
    }

    public void requestStoragePermissions() {
        List<String> permissions = this.getRequiredPermissions();
        if (permissions.isEmpty() || this.arePermissionsGranted()) {
            if (this.useFirstTimeStore && this.firstTimeStore != null) {
                this.firstTimeStore.storeFirstTime(1);
            }
            this.callback.onPermissionGranted();
        } else {
            this.requestPermissionLauncher.launch((Object)permissions.toArray(new String[0]));
        }
    }

    public void requestStoragePermissionsWithDialog(DialogConfig config) {
        if (this.arePermissionsGranted()) {
            if (this.useFirstTimeStore && this.firstTimeStore != null) {
                this.firstTimeStore.storeFirstTime(1);
            }
            this.callback.onPermissionGranted();
        } else {
            this.alertDialog = new CustomAlertDialog((Activity)this.activity, config, this);
            this.alertDialog.show();
        }
    }

    public boolean isFirstTime() {
        if (this.useFirstTimeStore && this.firstTimeStore != null) {
            return this.firstTimeStore.isFirstTime();
        }
        return true;
    }

    private List<String> getRequiredPermissions() {
        ArrayList<String> permissions = new ArrayList<String>();
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion >= 33) {
            permissions.add("android.permission.READ_MEDIA_AUDIO");
            permissions.add("android.permission.READ_MEDIA_VIDEO");
            permissions.add("android.permission.READ_MEDIA_IMAGES");
        } else if (sdkVersion >= 29) {
            permissions.add("android.permission.READ_EXTERNAL_STORAGE");
            if (sdkVersion < 30 || !this.isLegacyStorageSupported()) {
                permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
        } else if (sdkVersion >= 23) {
            permissions.add("android.permission.READ_EXTERNAL_STORAGE");
            permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
        }
        return permissions;
    }

    public boolean arePermissionsGranted() {
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion >= 33) {
            return this.hasPermission("android.permission.READ_MEDIA_AUDIO") && this.hasPermission("android.permission.READ_MEDIA_VIDEO") && this.hasPermission("android.permission.READ_MEDIA_IMAGES");
        }
        if (sdkVersion >= 29) {
            boolean readGranted = this.hasPermission("android.permission.READ_EXTERNAL_STORAGE");
            boolean writeGranted = sdkVersion < 30 || !this.isLegacyStorageSupported() ? this.hasPermission("android.permission.WRITE_EXTERNAL_STORAGE") : true;
            return readGranted && writeGranted;
        }
        if (sdkVersion >= 23) {
            return this.hasPermission("android.permission.READ_EXTERNAL_STORAGE") && this.hasPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        }
        return true;
    }

    private boolean hasPermission(String permission2) {
        return ContextCompat.checkSelfPermission((Context)this.activity, (String)permission2) == 0;
    }

    private boolean isLegacyStorageSupported() {
        if (Build.VERSION.SDK_INT >= 29 && Build.VERSION.SDK_INT <= 30) {
            return Environment.isExternalStorageLegacy();
        }
        return false;
    }

    public PermissionCallback getCallback() {
        return this.callback;
    }
}

