/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.util;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.folioreader.Config;
import com.folioreader.util.SharedPreferenceUtil;
import java.net.ServerSocket;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/folioreader/util/AppUtil;", "", "()V", "Companion", "folioreader_release"})
public final class AppUtil {
    private static final String SMIL_ELEMENTS = "smil_elements";
    private static final String LOG_TAG;
    private static final String FOLIO_READER_ROOT = "folioreader";
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        SMIL_ELEMENTS = SMIL_ELEMENTS;
        LOG_TAG = AppUtil.class.getSimpleName();
        FOLIO_READER_ROOT = FOLIO_READER_ROOT;
    }

    @JvmStatic
    @NotNull
    public static final String charsetNameForURLConnection(@NotNull URLConnection connection) {
        return Companion.charsetNameForURLConnection(connection);
    }

    @JvmStatic
    @NotNull
    public static final String formatDate(@NotNull Date hightlightDate) {
        return Companion.formatDate(hightlightDate);
    }

    @JvmStatic
    @Nullable
    public static final Config getSavedConfig(@Nullable Context context) {
        return Companion.getSavedConfig(context);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u0014J\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010\u001f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/folioreader/util/AppUtil$Companion;", "", "()V", "FOLIO_READER_ROOT", "", "LOG_TAG", "kotlin.jvm.PlatformType", "SMIL_ELEMENTS", "actionToString", "action", "", "charsetNameForURLConnection", "connection", "Ljava/net/URLConnection;", "formatDate", "hightlightDate", "Ljava/util/Date;", "getAvailablePortNumber", "portNumber", "getSavedConfig", "Lcom/folioreader/Config;", "context", "Landroid/content/Context;", "hideKeyboard", "", "activity", "Landroid/app/Activity;", "saveConfig", "config", "toMap", "", "jsonString", "FileType", "folioreader_release"})
    public static final class Companion {
        @NotNull
        public final Map<String, String> toMap(@NotNull String jsonString) {
            Intrinsics.checkParameterIsNotNull((Object)jsonString, (String)"jsonString");
            HashMap map = new HashMap();
            try {
                JSONArray jsonArray = new JSONArray(jsonString);
                JSONObject jObject = jsonArray.getJSONObject(0);
                Iterator keysItr = jObject.keys();
                while (keysItr.hasNext()) {
                    String string2;
                    String key = (String)keysItr.next();
                    Map<String, String> value = null;
                    value = jObject.get(key);
                    if (value instanceof JSONObject) {
                        value = this.toMap(value.toString());
                    }
                    Map map2 = map;
                    Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
                    Map<String, String> map3 = value;
                    if (map3 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string3 = map3.toString();
                    map2.put(string2, string3);
                }
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)"toMap failed", (Throwable)e);
            }
            return map;
        }

        @JvmStatic
        @NotNull
        public final String charsetNameForURLConnection(@NotNull URLConnection connection) {
            List list;
            String[] stringArray;
            Collection $receiver$iv;
            String contentType;
            Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
            String string2 = contentType = connection.getContentType();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"contentType");
            Object object = string2;
            CharSequence charSequence = ";";
            charSequence = new Regex((String)charSequence);
            int n = 0;
            object = charSequence.split((CharSequence)object, n);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    stringArray = (String[])it;
                    if (stringArray.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $receiver$iv = list;
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] values = stringArray2;
            String charset = null;
            stringArray = values;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                String value;
                String string3;
                String _value;
                String $receiver$iv2 = _value = stringArray[i];
                CharSequence $receiver$iv$iv = $receiver$iv2;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $receiver$iv$iv.charAt(index$iv$iv);
                    boolean bl = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String string4 = string3 = (value = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                if (!StringsKt.startsWith$default((String)string5, (String)"charset=", (boolean)false, (int)2, null)) continue;
                string3 = value;
                int n3 = "charset=".length();
                String string6 = string3;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                charset = string7;
                break;
            }
            if (charset == null || (charSequence = (CharSequence)charset).length() == 0) {
                charset = "UTF-8";
            }
            return charset;
        }

        @JvmStatic
        @NotNull
        public final String formatDate(@NotNull Date hightlightDate) {
            Intrinsics.checkParameterIsNotNull((Object)hightlightDate, (String)"hightlightDate");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy | HH:mm", Locale.getDefault());
            String string2 = simpleDateFormat.format(hightlightDate);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"simpleDateFormat.format(hightlightDate)");
            return string2;
        }

        public final void saveConfig(@Nullable Context context, @NotNull Config config) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            JSONObject obj = new JSONObject();
            try {
                obj.put("font", config.getFont());
                obj.put("font_size", config.getFontSize());
                obj.put("is_night_mode", config.isNightMode());
                obj.put("theme_color_int", config.getThemeColor());
                obj.put("is_tts", config.isShowTts());
                obj.put("allowed_direction", (Object)config.getAllowedDirection().toString());
                obj.put("direction", (Object)config.getDirection().toString());
                SharedPreferenceUtil.putSharedPreferencesString(context, "config", obj.toString());
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)e.getMessage());
            }
        }

        @JvmStatic
        @Nullable
        public final Config getSavedConfig(@Nullable Context context) {
            String json = SharedPreferenceUtil.getSharedPreferencesString(context, "config", null);
            if (json != null) {
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    return new Config(jsonObject);
                }
                catch (JSONException e) {
                    Log.e((String)LOG_TAG, (String)e.getMessage());
                    return null;
                }
            }
            return null;
        }

        @NotNull
        public final String actionToString(int action) {
            switch (action) {
                case 0: {
                    return "ACTION_DOWN";
                }
                case 1: {
                    return "ACTION_UP";
                }
                case 3: {
                    return "ACTION_CANCEL";
                }
                case 4: {
                    return "ACTION_OUTSIDE";
                }
                case 2: {
                    return "ACTION_MOVE";
                }
                case 7: {
                    return "ACTION_HOVER_MOVE";
                }
                case 8: {
                    return "ACTION_SCROLL";
                }
                case 9: {
                    return "ACTION_HOVER_ENTER";
                }
                case 10: {
                    return "ACTION_HOVER_EXIT";
                }
            }
            if (Build.VERSION.SDK_INT >= 23) {
                switch (action) {
                    case 11: {
                        return "ACTION_BUTTON_PRESS";
                    }
                    case 12: {
                        return "ACTION_BUTTON_RELEASE";
                    }
                }
            }
            int index = (action & 0xFF00) >> 8;
            switch (action & 0xFF) {
                case 5: {
                    return "ACTION_POINTER_DOWN(" + index + ')';
                }
                case 6: {
                    return "ACTION_POINTER_UP(" + index + ')';
                }
            }
            String string2 = Integer.toString(action);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Integer.toString(action)");
            return string2;
        }

        public final void hideKeyboard(@NotNull Activity activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Object object = activity.getSystemService("input_method");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
            }
            InputMethodManager imm = (InputMethodManager)object;
            View view = activity.getCurrentFocus();
            if (view == null) {
                view = new View((Context)activity);
            }
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            view.clearFocus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int getAvailablePortNumber(int portNumber) {
            int portNumberAvailable;
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(portNumber);
                Log.d((String)LOG_TAG, (String)("-> getAvailablePortNumber -> portNumber " + portNumber + " available"));
                portNumberAvailable = portNumber;
            }
            catch (Exception e) {
                try {
                    serverSocket = new ServerSocket(0);
                    portNumberAvailable = serverSocket.getLocalPort();
                    Log.w((String)LOG_TAG, (String)("-> getAvailablePortNumber -> portNumber " + portNumber + " not available, " + portNumberAvailable + " is available"));
                }
                catch (Throwable throwable) {
                    ServerSocket serverSocket2 = serverSocket;
                    if (serverSocket2 != null) {
                        serverSocket2.close();
                    }
                    throw throwable;
                }
                serverSocket.close();
            }
            serverSocket.close();
            return portNumberAvailable;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/folioreader/util/AppUtil$Companion$FileType;", "", "(Ljava/lang/String;I)V", "OPS", "OEBPS", "NONE", "folioreader_release"})
        private static final class FileType
        extends Enum<FileType> {
            public static final /* enum */ FileType OPS;
            public static final /* enum */ FileType OEBPS;
            public static final /* enum */ FileType NONE;
            private static final /* synthetic */ FileType[] $VALUES;

            static {
                FileType[] fileTypeArray = new FileType[3];
                FileType[] fileTypeArray2 = fileTypeArray;
                fileTypeArray[0] = OPS = new FileType();
                fileTypeArray[1] = OEBPS = new FileType();
                fileTypeArray[2] = NONE = new FileType();
                $VALUES = fileTypeArray;
            }

            public static FileType[] values() {
                return (FileType[])$VALUES.clone();
            }

            public static FileType valueOf(String string2) {
                return Enum.valueOf(FileType.class, string2);
            }
        }
    }
}

