/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.SeekBar;
import androidx.appcompat.widget.AppCompatSeekBar;

public class VerticalSeekbar
extends AppCompatSeekBar {
    private SeekBar.OnSeekBarChangeListener mOnChangeListener;
    private int mLastProgress = 0;

    public VerticalSeekbar(Context context) {
        super(context);
    }

    public VerticalSeekbar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public VerticalSeekbar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(h, w, oldh, oldw);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(heightMeasureSpec, widthMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
    }

    protected void onDraw(Canvas c) {
        c.rotate(90.0f);
        c.translate(0.0f, (float)(-this.getWidth()));
        super.onDraw(c);
    }

    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener mOnChangeListener) {
        this.mOnChangeListener = mOnChangeListener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.mOnChangeListener != null) {
                    this.mOnChangeListener.onStartTrackingTouch((SeekBar)this);
                }
                this.setPressed(true);
                this.setSelected(true);
                break;
            }
            case 2: {
                super.onTouchEvent(event);
                int progress = this.getMax() - (int)((float)this.getMax() * event.getY() / (float)this.getHeight());
                if (progress < 0) {
                    progress = 0;
                }
                if (progress > this.getMax()) {
                    progress = this.getMax();
                }
                this.setProgress(progress);
                if (progress != this.mLastProgress) {
                    this.mLastProgress = progress;
                    if (this.mOnChangeListener != null) {
                        this.mOnChangeListener.onProgressChanged((SeekBar)this, progress, true);
                    }
                }
                this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                this.setPressed(true);
                this.setSelected(true);
                break;
            }
            case 1: {
                if (this.mOnChangeListener != null) {
                    this.mOnChangeListener.onStopTrackingTouch((SeekBar)this);
                }
                this.setPressed(false);
                this.setSelected(false);
                break;
            }
            case 3: {
                super.onTouchEvent(event);
                this.setPressed(false);
                this.setSelected(false);
            }
        }
        return true;
    }

    public synchronized void setProgressAndThumb(int progress) {
        this.setProgress(progress);
        this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
        if (progress != this.mLastProgress) {
            this.mLastProgress = progress;
            if (this.mOnChangeListener != null) {
                this.mOnChangeListener.onProgressChanged((SeekBar)this, progress, true);
            }
        }
    }

    public synchronized void setMaximum(int maximum) {
        this.setMax(maximum);
    }

    public synchronized int getMaximum() {
        return this.getMax();
    }
}

