/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.activity;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.ui.fragment.HighlightFragment;
import com.folioreader.ui.fragment.TableOfContentFragment;
import com.folioreader.util.AppUtil;
import com.folioreader.util.UiUtil;
import org.readium.r2.shared.Publication;

public class ContentHighlightActivity
extends AppCompatActivity {
    private boolean mIsNightMode;
    private Config mConfig;
    private Publication publication;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_content_highlight);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().hide();
        }
        this.publication = (Publication)this.getIntent().getSerializableExtra("PUBLICATION");
        this.mConfig = AppUtil.getSavedConfig((Context)this);
        this.mIsNightMode = this.mConfig != null && this.mConfig.isNightMode();
        this.initViews();
    }

    private void initViews() {
        UiUtil.setColorIntToDrawable(this.mConfig.getThemeColor(), ((ImageView)this.findViewById(R.id.btn_close)).getDrawable());
        this.findViewById(R.id.layout_content_highlights).setBackgroundDrawable((Drawable)UiUtil.getShapeDrawable(this.mConfig.getThemeColor()));
        if (this.mIsNightMode) {
            this.findViewById(R.id.toolbar).setBackgroundColor(-16777216);
            this.findViewById(R.id.btn_contents).setBackgroundDrawable((Drawable)UiUtil.createStateDrawable(this.mConfig.getThemeColor(), ContextCompat.getColor((Context)this, (int)R.color.black)));
            this.findViewById(R.id.btn_highlights).setBackgroundDrawable((Drawable)UiUtil.createStateDrawable(this.mConfig.getThemeColor(), ContextCompat.getColor((Context)this, (int)R.color.black)));
            ((TextView)this.findViewById(R.id.btn_contents)).setTextColor(UiUtil.getColorList(ContextCompat.getColor((Context)this, (int)R.color.black), this.mConfig.getThemeColor()));
            ((TextView)this.findViewById(R.id.btn_highlights)).setTextColor(UiUtil.getColorList(ContextCompat.getColor((Context)this, (int)R.color.black), this.mConfig.getThemeColor()));
        } else {
            ((TextView)this.findViewById(R.id.btn_contents)).setTextColor(UiUtil.getColorList(ContextCompat.getColor((Context)this, (int)R.color.white), this.mConfig.getThemeColor()));
            ((TextView)this.findViewById(R.id.btn_highlights)).setTextColor(UiUtil.getColorList(ContextCompat.getColor((Context)this, (int)R.color.white), this.mConfig.getThemeColor()));
            this.findViewById(R.id.btn_contents).setBackgroundDrawable((Drawable)UiUtil.createStateDrawable(this.mConfig.getThemeColor(), ContextCompat.getColor((Context)this, (int)R.color.white)));
            this.findViewById(R.id.btn_highlights).setBackgroundDrawable((Drawable)UiUtil.createStateDrawable(this.mConfig.getThemeColor(), ContextCompat.getColor((Context)this, (int)R.color.white)));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            int color2;
            if (this.mIsNightMode) {
                color2 = ContextCompat.getColor((Context)this, (int)R.color.black);
            } else {
                int[] attrs = new int[]{16843858};
                TypedArray typedArray = this.getTheme().obtainStyledAttributes(attrs);
                color2 = typedArray.getColor(0, ContextCompat.getColor((Context)this, (int)R.color.white));
            }
            this.getWindow().setNavigationBarColor(color2);
        }
        this.loadContentFragment();
        this.findViewById(R.id.btn_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ContentHighlightActivity.this.finish();
            }
        });
        this.findViewById(R.id.btn_contents).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ContentHighlightActivity.this.loadContentFragment();
            }
        });
        this.findViewById(R.id.btn_highlights).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ContentHighlightActivity.this.loadHighlightsFragment();
            }
        });
    }

    private void loadContentFragment() {
        this.findViewById(R.id.btn_contents).setSelected(true);
        this.findViewById(R.id.btn_highlights).setSelected(false);
        TableOfContentFragment contentFrameLayout = TableOfContentFragment.newInstance(this.publication, this.getIntent().getStringExtra("chapter_selected"), this.getIntent().getStringExtra("book_title"));
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        ft.replace(R.id.parent, (Fragment)contentFrameLayout);
        ft.commit();
    }

    private void loadHighlightsFragment() {
        this.findViewById(R.id.btn_contents).setSelected(false);
        this.findViewById(R.id.btn_highlights).setSelected(true);
        String bookId = this.getIntent().getStringExtra("com.folioreader.extra.BOOK_ID");
        String bookTitle = this.getIntent().getStringExtra("book_title");
        HighlightFragment highlightFragment = HighlightFragment.newInstance(bookId, bookTitle);
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        ft.replace(R.id.parent, (Fragment)highlightFragment);
        ft.commit();
    }
}

