/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.suggestfield.demo;

import com.vaadin.data.HasValue;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.ShortcutListener;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.vaadin.suggestfield.SuggestField;
import org.vaadin.suggestfield.demo.CountryBean;
import org.vaadin.suggestfield.demo.SuggestFieldDemo;

public class SuggestFieldDemo
extends VerticalLayout {
    long id = 0L;
    private final SuggestField<CountryBean> search1 = new SuggestField((SuggestField.SuggestionConverter)new CountrySuggestionConverter(this));
    private final SuggestField<CountryBean> search2 = new SuggestField((SuggestField.SuggestionConverter)new CountrySuggestionConverter(this));
    private List<CountryBean> items = new ArrayList();

    public SuggestFieldDemo() {
        this.setStyleName("demoContentLayout");
        this.setWidth("100%");
        this.setSpacing(true);
        this.setMargin(true);
        this.addComponent((Component)this.search1);
        this.addShortcutListener((ShortcutListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buildItems();
        Button btnEnabled = new Button("Set enabled/disabled");
        btnEnabled.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        Button btnSetValue = new Button("Set field value");
        btnSetValue.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        Button btnGetValue = new Button("Get field value");
        btnGetValue.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.search1.setPlaceholder("Type country name");
        this.search1.setEnabled(true);
        this.search1.setWidth("600px");
        this.search1.setPopupWidth(600);
        this.setUpAutocomplete(this.search1);
        this.search1.setShortCut(83, new int[]{17});
        this.addComponent((Component)btnEnabled);
        this.addComponent((Component)btnSetValue);
        this.addComponent((Component)btnGetValue);
        this.search2.setPlaceholder("Type something");
        this.search2.setWidth("400px");
        this.setUpAutocomplete(this.search2);
        TabSheet tab = new TabSheet();
        this.addComponent((Component)tab);
        this.setExpandRatio((Component)tab, 1.0f);
        tab.addTab((Component)this.search2, "Search");
        tab.addTab((Component)new Label("Suggest field demo"), "Demo");
    }

    private void setUpAutocomplete(SuggestField<CountryBean> search) {
        search.setSuggestionHandler((SuggestField.SuggestionHandler & Serializable)query -> {
            System.out.println("Query: " + query);
            return this.handleSearchQuery(query);
        });
        search.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            System.out.println("SuugestField value changed");
            Notification.show((String)("Selected " + search.getValue()));
        });
        search.setNewItemsHandler((SuggestField.NewItemsHandler & Serializable)newItemText -> {
            CountryBean newValue = new CountryBean(Long.valueOf(this.id++), newItemText);
            this.items.add(newValue);
            return newValue;
        });
        search.setNewItemsAllowed(true);
        search.addFocusListener((FieldEvents.FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        search.addBlurListener((FieldEvents.BlurListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void handleSuggestionSelection(Integer suggestion) {
        Notification.show((String)("Selected " + suggestion));
    }

    private List<CountryBean> handleSearchQuery(String query) {
        if ("".equals(query) || query == null) {
            return Collections.emptyList();
        }
        ArrayList<CountryBean> result = new ArrayList<CountryBean>();
        for (CountryBean country : this.items) {
            if (!country.getName().toLowerCase().startsWith(query.toLowerCase())) continue;
            result.add(country);
        }
        System.out.println("Total: " + result.size());
        return result;
    }

    private void buildItems() {
        this.items.addAll(Arrays.asList(new CountryBean(Long.valueOf(this.id++), "Afghanistan"), new CountryBean(Long.valueOf(this.id++), "Albania"), new CountryBean(Long.valueOf(this.id++), "Algeria"), new CountryBean(Long.valueOf(this.id++), "Andorra"), new CountryBean(Long.valueOf(this.id++), "Angola"), new CountryBean(Long.valueOf(this.id++), "Antigua and Barbuda"), new CountryBean(Long.valueOf(this.id++), "Argentina"), new CountryBean(Long.valueOf(this.id++), "Armenia"), new CountryBean(Long.valueOf(this.id++), "Australia"), new CountryBean(Long.valueOf(this.id++), "Austria"), new CountryBean(Long.valueOf(this.id++), "Azerbaijan"), new CountryBean(Long.valueOf(this.id++), "Bahamas"), new CountryBean(Long.valueOf(this.id++), "Bahrain"), new CountryBean(Long.valueOf(this.id++), "Bangladesh"), new CountryBean(Long.valueOf(this.id++), "Barbados"), new CountryBean(Long.valueOf(this.id++), "Belarus"), new CountryBean(Long.valueOf(this.id++), "Belgium"), new CountryBean(Long.valueOf(this.id++), "Belize"), new CountryBean(Long.valueOf(this.id++), "Benin"), new CountryBean(Long.valueOf(this.id++), "Bhutan"), new CountryBean(Long.valueOf(this.id++), "Bolivia"), new CountryBean(Long.valueOf(this.id++), "Bosnia and Herzegovina"), new CountryBean(Long.valueOf(this.id++), "Botswana"), new CountryBean(Long.valueOf(this.id++), "Brazil"), new CountryBean(Long.valueOf(this.id++), "Brunei Darussalam"), new CountryBean(Long.valueOf(this.id++), "Bulgaria"), new CountryBean(Long.valueOf(this.id++), "Burkina Faso"), new CountryBean(Long.valueOf(this.id++), "Burundi"), new CountryBean(Long.valueOf(this.id++), "Cabo Verde"), new CountryBean(Long.valueOf(this.id++), "Cambodia"), new CountryBean(Long.valueOf(this.id++), "Cameroon"), new CountryBean(Long.valueOf(this.id++), "Canada"), new CountryBean(Long.valueOf(this.id++), "Central African Republic"), new CountryBean(Long.valueOf(this.id++), "Chad"), new CountryBean(Long.valueOf(this.id++), "Chile"), new CountryBean(Long.valueOf(this.id++), "China"), new CountryBean(Long.valueOf(this.id++), "Colombia"), new CountryBean(Long.valueOf(this.id++), "Comoros"), new CountryBean(Long.valueOf(this.id++), "Congo"), new CountryBean(Long.valueOf(this.id++), "Democratic Republic of the Congo"), new CountryBean(Long.valueOf(this.id++), "Costa Rica"), new CountryBean(Long.valueOf(this.id++), "C\u00f4te d'Ivoire"), new CountryBean(Long.valueOf(this.id++), "Croatia"), new CountryBean(Long.valueOf(this.id++), "Cuba"), new CountryBean(Long.valueOf(this.id++), "Cyprus"), new CountryBean(Long.valueOf(this.id++), "Czech Republic"), new CountryBean(Long.valueOf(this.id++), "Denmark"), new CountryBean(Long.valueOf(this.id++), "Djibouti"), new CountryBean(Long.valueOf(this.id++), "Dominica"), new CountryBean(Long.valueOf(this.id++), "Dominican Republic"), new CountryBean(Long.valueOf(this.id++), "Ecuador"), new CountryBean(Long.valueOf(this.id++), "Egypt"), new CountryBean(Long.valueOf(this.id++), "El Salvador"), new CountryBean(Long.valueOf(this.id++), "Equatorial Guinea"), new CountryBean(Long.valueOf(this.id++), "Eritrea"), new CountryBean(Long.valueOf(this.id++), "Estonia"), new CountryBean(Long.valueOf(this.id++), "Ethiopia"), new CountryBean(Long.valueOf(this.id++), "Fiji"), new CountryBean(Long.valueOf(this.id++), "Finland"), new CountryBean(Long.valueOf(this.id++), "France"), new CountryBean(Long.valueOf(this.id++), "Gabon"), new CountryBean(Long.valueOf(this.id++), "Gambia"), new CountryBean(Long.valueOf(this.id++), "Georgia"), new CountryBean(Long.valueOf(this.id++), "Germany"), new CountryBean(Long.valueOf(this.id++), "Ghana"), new CountryBean(Long.valueOf(this.id++), "Greece"), new CountryBean(Long.valueOf(this.id++), "Grenada"), new CountryBean(Long.valueOf(this.id++), "Guatemala"), new CountryBean(Long.valueOf(this.id++), "Guinea"), new CountryBean(Long.valueOf(this.id++), "Guinea-Bissau"), new CountryBean(Long.valueOf(this.id++), "Guyana"), new CountryBean(Long.valueOf(this.id++), "Haiti"), new CountryBean(Long.valueOf(this.id++), "Honduras"), new CountryBean(Long.valueOf(this.id++), "Hungary"), new CountryBean(Long.valueOf(this.id++), "Iceland"), new CountryBean(Long.valueOf(this.id++), "India"), new CountryBean(Long.valueOf(this.id++), "Indonesia"), new CountryBean(Long.valueOf(this.id++), "Iran (Islamic Republic of)"), new CountryBean(Long.valueOf(this.id++), "Iraq"), new CountryBean(Long.valueOf(this.id++), "Ireland"), new CountryBean(Long.valueOf(this.id++), "Israel"), new CountryBean(Long.valueOf(this.id++), "Italy"), new CountryBean(Long.valueOf(this.id++), "Jamaica"), new CountryBean(Long.valueOf(this.id++), "Japan"), new CountryBean(Long.valueOf(this.id++), "Jordan"), new CountryBean(Long.valueOf(this.id++), "Kazakhstan"), new CountryBean(Long.valueOf(this.id++), "Kenya"), new CountryBean(Long.valueOf(this.id++), "Kiribati"), new CountryBean(Long.valueOf(this.id++), "Democratic People's Republic of Korea"), new CountryBean(Long.valueOf(this.id++), "Republic of Korea"), new CountryBean(Long.valueOf(this.id++), "Kuwait"), new CountryBean(Long.valueOf(this.id++), "Kyrgyzstan"), new CountryBean(Long.valueOf(this.id++), "Lao People's Democratic Republic"), new CountryBean(Long.valueOf(this.id++), "Latvia"), new CountryBean(Long.valueOf(this.id++), "Lebanon"), new CountryBean(Long.valueOf(this.id++), "Lesotho"), new CountryBean(Long.valueOf(this.id++), "Liberia"), new CountryBean(Long.valueOf(this.id++), "Libya"), new CountryBean(Long.valueOf(this.id++), "Liechtenstein"), new CountryBean(Long.valueOf(this.id++), "Lithuania"), new CountryBean(Long.valueOf(this.id++), "Luxembourg"), new CountryBean(Long.valueOf(this.id++), "The former Yugoslav Republic of Macedonia"), new CountryBean(Long.valueOf(this.id++), "Madagascar"), new CountryBean(Long.valueOf(this.id++), "Malawi"), new CountryBean(Long.valueOf(this.id++), "Malaysia"), new CountryBean(Long.valueOf(this.id++), "Maldives"), new CountryBean(Long.valueOf(this.id++), "Mali"), new CountryBean(Long.valueOf(this.id++), "Malta"), new CountryBean(Long.valueOf(this.id++), "Marshall Islands"), new CountryBean(Long.valueOf(this.id++), "Mauritania"), new CountryBean(Long.valueOf(this.id++), "Mauritius"), new CountryBean(Long.valueOf(this.id++), "Mexico"), new CountryBean(Long.valueOf(this.id++), "Micronesia (Federated States of)"), new CountryBean(Long.valueOf(this.id++), "Republic of Moldova"), new CountryBean(Long.valueOf(this.id++), "Monaco"), new CountryBean(Long.valueOf(this.id++), "Mongolia"), new CountryBean(Long.valueOf(this.id++), "Montenegro"), new CountryBean(Long.valueOf(this.id++), "Morocco"), new CountryBean(Long.valueOf(this.id++), "Mozambique"), new CountryBean(Long.valueOf(this.id++), "Myanmar"), new CountryBean(Long.valueOf(this.id++), "Namibia"), new CountryBean(Long.valueOf(this.id++), "Nauru"), new CountryBean(Long.valueOf(this.id++), "Nepal"), new CountryBean(Long.valueOf(this.id++), "Netherlands"), new CountryBean(Long.valueOf(this.id++), "New Zealand"), new CountryBean(Long.valueOf(this.id++), "Nicaragua"), new CountryBean(Long.valueOf(this.id++), "Niger"), new CountryBean(Long.valueOf(this.id++), "Nigeria"), new CountryBean(Long.valueOf(this.id++), "Norway"), new CountryBean(Long.valueOf(this.id++), "Oman"), new CountryBean(Long.valueOf(this.id++), "Pakistan"), new CountryBean(Long.valueOf(this.id++), "Palau"), new CountryBean(Long.valueOf(this.id++), "Panama"), new CountryBean(Long.valueOf(this.id++), "Papua New Guinea"), new CountryBean(Long.valueOf(this.id++), "Paraguay"), new CountryBean(Long.valueOf(this.id++), "Peru"), new CountryBean(Long.valueOf(this.id++), "Philippines"), new CountryBean(Long.valueOf(this.id++), "Poland"), new CountryBean(Long.valueOf(this.id++), "Portugal"), new CountryBean(Long.valueOf(this.id++), "Qatar"), new CountryBean(Long.valueOf(this.id++), "Romania"), new CountryBean(Long.valueOf(this.id++), "Russian Federation"), new CountryBean(Long.valueOf(this.id++), "Rwanda"), new CountryBean(Long.valueOf(this.id++), "Saint Kitts and Nevis"), new CountryBean(Long.valueOf(this.id++), "Saint Lucia"), new CountryBean(Long.valueOf(this.id++), "Saint Vincent and the Grenadines"), new CountryBean(Long.valueOf(this.id++), "Samoa"), new CountryBean(Long.valueOf(this.id++), "San Marino"), new CountryBean(Long.valueOf(this.id++), "Sao Tome and Principe"), new CountryBean(Long.valueOf(this.id++), "Saudi Arabia"), new CountryBean(Long.valueOf(this.id++), "Senegal"), new CountryBean(Long.valueOf(this.id++), "Serbia"), new CountryBean(Long.valueOf(this.id++), "Seychelles"), new CountryBean(Long.valueOf(this.id++), "Sierra Leone"), new CountryBean(Long.valueOf(this.id++), "Singapore"), new CountryBean(Long.valueOf(this.id++), "Slovakia"), new CountryBean(Long.valueOf(this.id++), "Slovenia"), new CountryBean(Long.valueOf(this.id++), "Solomon Islands"), new CountryBean(Long.valueOf(this.id++), "Somalia"), new CountryBean(Long.valueOf(this.id++), "South Africa"), new CountryBean(Long.valueOf(this.id++), "South Sudan"), new CountryBean(Long.valueOf(this.id++), "Spain"), new CountryBean(Long.valueOf(this.id++), "Sri Lanka"), new CountryBean(Long.valueOf(this.id++), "Sudan"), new CountryBean(Long.valueOf(this.id++), "Suriname"), new CountryBean(Long.valueOf(this.id++), "Swaziland"), new CountryBean(Long.valueOf(this.id++), "Sweden"), new CountryBean(Long.valueOf(this.id++), "Switzerland"), new CountryBean(Long.valueOf(this.id++), "Syrian Arab Republic"), new CountryBean(Long.valueOf(this.id++), "Tajikistan"), new CountryBean(Long.valueOf(this.id++), "United Republic of Tanzania"), new CountryBean(Long.valueOf(this.id++), "Thailand"), new CountryBean(Long.valueOf(this.id++), "Timor-Leste"), new CountryBean(Long.valueOf(this.id++), "Togo"), new CountryBean(Long.valueOf(this.id++), "Tonga"), new CountryBean(Long.valueOf(this.id++), "Trinidad and Tobago"), new CountryBean(Long.valueOf(this.id++), "Tunisia"), new CountryBean(Long.valueOf(this.id++), "Turkey"), new CountryBean(Long.valueOf(this.id++), "Turkmenistan"), new CountryBean(Long.valueOf(this.id++), "Tuvalu"), new CountryBean(Long.valueOf(this.id++), "Uganda"), new CountryBean(Long.valueOf(this.id++), "Ukraine"), new CountryBean(Long.valueOf(this.id++), "United Arab Emirates"), new CountryBean(Long.valueOf(this.id++), "United Kingdom of Great Britain and Northern Ireland"), new CountryBean(Long.valueOf(this.id++), "United States of America"), new CountryBean(Long.valueOf(this.id++), "Uruguay"), new CountryBean(Long.valueOf(this.id++), "Uzbekistan"), new CountryBean(Long.valueOf(this.id++), "Vanuatu"), new CountryBean(Long.valueOf(this.id++), "Venezuela (Bolivarian Republic of)"), new CountryBean(Long.valueOf(this.id++), "Viet Nam"), new CountryBean(Long.valueOf(this.id++), "Yemen"), new CountryBean(Long.valueOf(this.id++), "Zambia"), new CountryBean(Long.valueOf(this.id++), "Zimbabwe")));
    }

    static /* synthetic */ SuggestField access$000(SuggestFieldDemo x0) {
        return x0.search1;
    }

    static /* synthetic */ List access$100(SuggestFieldDemo x0) {
        return x0.items;
    }

    static /* synthetic */ SuggestField access$200(SuggestFieldDemo x0) {
        return x0.search2;
    }
}

