/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.suggestfield.demo;

import com.vaadin.data.ValidationResult;
import com.vaadin.data.validator.EmailValidator;
import com.vaadin.event.LayoutEvents;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.shared.Registration;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.vaadin.suggestfield.SuggestField;

public class AddressEditor
extends CssLayout {
    private SuggestField<String> suggestField;
    private List<String> addresses = new LinkedList();
    private EmailValidator validator;
    private Registration addressRemoveRegistration;

    public AddressEditor() {
        this.setWidth("100%");
        this.addStyleName("wrapping");
        this.addStyleName("address-editor");
        this.suggestField = SuggestField.forString();
        this.suggestField.setNewItemsAllowed(true);
        this.suggestField.setNewItemsHandler((SuggestField.NewItemsHandler & Serializable)newItemText -> {
            if (!this.validator.apply(newItemText, null).isError()) {
                this.addresses.add(newItemText);
            }
            return newItemText;
        });
        this.suggestField.setTokenMode(true);
        this.suggestField.setSuggestionHandler(arg_0 -> this.searchItems(arg_0));
        this.suggestField.setTokenHandler((SuggestField.TokenHandler & Serializable)token -> {
            if (token != null) {
                String address = token;
                if (!this.getValue().contains(address)) {
                    this.addToken(this.generateToken(address));
                }
            }
        });
        this.suggestField.setWidth("250px");
        this.suggestField.setPopupWidth(400);
        this.addComponent((Component)this.suggestField);
        this.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)event -> {
            if (event.getClickedComponent() == null) {
                this.suggestField.focus();
            }
        });
        this.validator = new EmailValidator("Invalid email address");
    }

    private List<String> searchItems(String query) {
        if ("".equals(query) || query == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        int count = 0;
        for (String address : this.addresses) {
            if (!address.toLowerCase().startsWith(query.toLowerCase()) || count >= 10) continue;
            result.add(address);
            ++count;
        }
        System.out.println("Total: " + result.size());
        return new ArrayList<String>(result);
    }

    private void clearAddresses() {
        while (this.getComponentCount() > 1) {
            if (!(this.getComponent(0) instanceof Button)) continue;
            Button btn = (Button)this.getComponent(0);
            this.addressRemoveRegistration.remove();
            this.removeComponent((Component)btn);
        }
    }

    public boolean isValid(boolean required) {
        boolean valid = true;
        int count = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof Button)) continue;
            ++count;
            Button btn = (Button)this.getComponent(i);
            String address = (String)btn.getData();
            if (!this.validator.apply(address, null).isError()) continue;
            valid = false;
            break;
        }
        if (required && count == 0) {
            valid = false;
        }
        return valid;
    }

    public List<String> getValue() {
        LinkedList<String> values = new LinkedList<String>();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof Button)) continue;
            Button btn = (Button)this.getComponent(i);
            values.add((String)btn.getData());
        }
        return values;
    }

    public void setValue(List<String> value) {
        this.clearAddresses();
        if (value != null) {
            for (String address : value) {
                this.addToken(this.generateToken(address));
            }
        }
    }

    private void addToken(Button button) {
        int index = this.getComponentIndex((Component)this.suggestField);
        this.addComponent((Component)button, index);
    }

    private Button generateToken(String address) {
        Button btn = new Button(address, (Resource)VaadinIcons.CLOSE);
        btn.setData((Object)address);
        btn.addStyleName("small");
        btn.addStyleName("icon-align-right");
        this.addressRemoveRegistration = btn.addClickListener((Button.ClickListener & Serializable)event -> this.removeComponent((Component)event.getButton()));
        ValidationResult validationResult = this.validator.apply(address, null);
        if (!validationResult.isError()) {
            btn.setDescription("Click to remove");
        } else {
            btn.addStyleName("danger");
            btn.setDescription(validationResult.getErrorMessage());
        }
        return btn;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.suggestField.setEnabled(enabled);
    }

    public void setAddresses(List<String> addresses) {
        this.addresses.clear();
        this.addresses.addAll(addresses);
    }
}

