/*
 * Decompiled with CFR 0.152.
 */
package com.f1reking.signatureview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import com.f1reking.signatureview.R;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SignatureView
extends View {
    private static final String TAG = SignatureView.class.getSimpleName();
    public static final int PEN_WIDTH = 10;
    public static final int PEN_COLOR = -16777216;
    public static final int BACK_COLOR = -1;
    private float mPenX;
    private float mPenY;
    private Paint mPaint = new Paint();
    private Path mPath = new Path();
    private Canvas mCanvas;
    private Bitmap cacheBitmap;
    private int mPentWidth = 10;
    private int mPenColor = -16777216;
    private int mBackColor = -1;
    private boolean isTouched = false;
    private String mSavePath = null;

    public SignatureView(Context context) {
        this(context, null);
    }

    public SignatureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignatureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SignatureView);
        this.mPenColor = typedArray.getColor(R.styleable.SignatureView_penColor, -16777216);
        this.mBackColor = typedArray.getColor(R.styleable.SignatureView_backColor, -1);
        this.mPentWidth = typedArray.getInt(R.styleable.SignatureView_penWidth, 10);
        typedArray.recycle();
        this.init();
    }

    private void init() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mPentWidth);
        this.mPaint.setColor(this.mPenColor);
    }

    public boolean getTouched() {
        return this.isTouched;
    }

    public void setPentWidth(int pentWidth) {
        this.mPentWidth = pentWidth;
    }

    public void setPenColor(@ColorInt int penColor) {
        this.mPenColor = penColor;
    }

    public void setBackColor(@ColorInt int backColor) {
        this.mBackColor = backColor;
    }

    public void clear() {
        if (this.mCanvas != null) {
            this.isTouched = false;
            this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
            this.mCanvas.drawColor(this.mBackColor);
            this.invalidate();
        }
    }

    public void save(String path, boolean clearBlank, int blank) throws IOException {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        this.mSavePath = path;
        Bitmap bitmap = this.cacheBitmap;
        if (clearBlank) {
            bitmap = this.clearBlank(bitmap, blank);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
        byte[] buffer = bos.toByteArray();
        if (buffer != null) {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream os = new FileOutputStream(file);
            ((OutputStream)os).write(buffer);
            ((OutputStream)os).close();
            bos.close();
        }
    }

    public Bitmap getBitmap() {
        this.setDrawingCacheEnabled(true);
        this.buildDrawingCache();
        Bitmap bitmap = this.getDrawingCache();
        this.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public String getSavePath() {
        return this.mSavePath;
    }

    private Bitmap clearBlank(Bitmap bmp, int blank) {
        int x;
        boolean isStop;
        int i;
        int height = bmp.getHeight();
        int width = bmp.getWidth();
        int top = 0;
        int left = 0;
        int right = 0;
        int bottom = 0;
        int[] pixs = new int[width];
        for (i = 0; i < height; ++i) {
            bmp.getPixels(pixs, 0, width, 0, i, width, 1);
            isStop = false;
            for (int pix : pixs) {
                if (pix == this.mBackColor) continue;
                top = i;
                isStop = true;
                break;
            }
            if (isStop) break;
        }
        for (i = height - 1; i >= 0; --i) {
            bmp.getPixels(pixs, 0, width, 0, i, width, 1);
            isStop = false;
            for (int pix : pixs) {
                if (pix == this.mBackColor) continue;
                bottom = i;
                isStop = true;
                break;
            }
            if (isStop) break;
        }
        pixs = new int[height];
        for (x = 0; x < width; ++x) {
            bmp.getPixels(pixs, 0, 1, x, 0, 1, height);
            isStop = false;
            for (int pix : pixs) {
                if (pix == this.mBackColor) continue;
                left = x;
                isStop = true;
                break;
            }
            if (isStop) break;
        }
        for (x = width - 1; x > 0; --x) {
            bmp.getPixels(pixs, 0, 1, x, 0, 1, height);
            isStop = false;
            for (int pix : pixs) {
                if (pix == this.mBackColor) continue;
                right = x;
                isStop = true;
                break;
            }
            if (isStop) break;
        }
        if (blank < 0) {
            blank = 0;
        }
        left = left - blank > 0 ? left - blank : 0;
        top = top - blank > 0 ? top - blank : 0;
        right = right + blank > width - 1 ? width - 1 : right + blank;
        bottom = bottom + blank > height - 1 ? height - 1 : bottom + blank;
        return Bitmap.createBitmap((Bitmap)bmp, (int)left, (int)top, (int)(right - left), (int)(bottom - top));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.cacheBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas = new Canvas(this.cacheBitmap);
        this.mCanvas.drawColor(this.mBackColor);
        this.isTouched = false;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawBitmap(this.cacheBitmap, 0.0f, 0.0f, this.mPaint);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mPenX = event.getX();
                this.mPenY = event.getY();
                this.mPath.moveTo(this.mPenX, this.mPenY);
                return true;
            }
            case 2: {
                this.isTouched = true;
                float x = event.getX();
                float y = event.getY();
                float penX = this.mPenX;
                float penY = this.mPenY;
                float dx = Math.abs(x - penX);
                float dy = Math.abs(y - penY);
                if (dx >= 3.0f || dy >= 3.0f) {
                    float cx = (x + penX) / 2.0f;
                    float cy = (y + penY) / 2.0f;
                    this.mPath.quadTo(penX, penY, cx, cy);
                    this.mPenX = x;
                    this.mPenY = y;
                }
                this.invalidate();
                break;
            }
            case 1: {
                this.mCanvas.drawPath(this.mPath, this.mPaint);
                this.mPath.reset();
                break;
            }
        }
        return super.onTouchEvent(event);
    }
}

