/*
 * Decompiled with CFR 0.152.
 */
package ua.naiksoftware.stomp.client;

import android.util.Log;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.disposables.Disposable;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.naiksoftware.stomp.ConnectionProvider;
import ua.naiksoftware.stomp.LifecycleEvent;
import ua.naiksoftware.stomp.StompHeader;
import ua.naiksoftware.stomp.client.StompClient;
import ua.naiksoftware.stomp.client.StompClient$WhenMappings;
import ua.naiksoftware.stomp.client.StompCommand;
import ua.naiksoftware.stomp.client.StompMessage;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 12\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0006J$\u0010\u001f\u001a\u00020\u001d2\u0010\b\u0002\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\b\b\u0002\u0010 \u001a\u00020\u0006H\u0007J\u0006\u0010$\u001a\u00020\u001dJ\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u0010)\u001a\u00020\u000fJ\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fJ\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u0010\u001e\u001a\u00020\u0012J(\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\b\u0010,\u001a\u0004\u0018\u00010\u000f2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"H\u0002J(\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00120&2\u0006\u0010,\u001a\u00020\u000f2\u0010\b\u0002\u0010-\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"H\u0007J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u00100\u001a\u00020\u000fH\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u001c\u0012\u0004\u0012\u00020\u000f\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00120\u00110\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lua/naiksoftware/stomp/client/StompClient;", "", "mConnectionProvider", "Lua/naiksoftware/stomp/ConnectionProvider;", "(Lua/naiksoftware/stomp/ConnectionProvider;)V", "<set-?>", "", "isConnected", "()Z", "setConnected", "(Z)V", "isConnecting", "setConnecting", "mEmitters", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lio/reactivex/FlowableEmitter;", "Lua/naiksoftware/stomp/client/StompMessage;", "mLifecycleDisposable", "Lio/reactivex/disposables/Disposable;", "mMessagesDisposable", "mTopics", "Ljava/util/HashMap;", "mWaitConnectionFlowables", "", "Lio/reactivex/flowables/ConnectableFlowable;", "Ljava/lang/Void;", "callSubscribers", "", "stompMessage", "connect", "reconnect", "_headers", "", "Lua/naiksoftware/stomp/StompHeader;", "disconnect", "lifecycle", "Lio/reactivex/Flowable;", "Lua/naiksoftware/stomp/LifecycleEvent;", "send", "destination", "data", "subscribePath", "destinationPath", "headerList", "topic", "unsubscribePath", "dest", "Companion", "lib_release"})
public final class StompClient {
    private Disposable mMessagesDisposable;
    private Disposable mLifecycleDisposable;
    private final ConcurrentHashMap<String, Set<FlowableEmitter<? super StompMessage>>> mEmitters;
    private final List<ConnectableFlowable<Void>> mWaitConnectionFlowables;
    private HashMap<String, String> mTopics;
    private boolean isConnected;
    private boolean isConnecting;
    private final ConnectionProvider mConnectionProvider;
    private static final String TAG;
    private static final String SUPPORTED_VERSIONS = "1.1,1.0";
    private static final String DEFAULT_ACK = "auto";
    public static final Companion Companion;

    public final boolean isConnected() {
        return this.isConnected;
    }

    private final void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    public final boolean isConnecting() {
        return this.isConnecting;
    }

    private final void setConnecting(boolean bl) {
        this.isConnecting = bl;
    }

    public final void connect(boolean reconnect) {
        this.connect(null, reconnect);
    }

    @JvmOverloads
    public final void connect(@Nullable List<? extends StompHeader> _headers, boolean reconnect) {
        if (reconnect) {
            this.disconnect();
        }
        if (this.isConnected) {
            return;
        }
        this.isConnecting = true;
        this.mLifecycleDisposable = this.lifecycle().subscribe((Consumer)new Consumer<LifecycleEvent>(this, _headers){
            final /* synthetic */ StompClient this$0;
            final /* synthetic */ List $_headers;

            public final void accept(LifecycleEvent lifecycleEvent) {
                Log.d((String)ua.naiksoftware.stomp.client.StompClient$Companion.access$getTAG$p(StompClient.Companion), (String)("Received lifecycle event " + lifecycleEvent));
                LifecycleEvent.Type type = lifecycleEvent.getType();
                if (type != null) {
                    switch (StompClient$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
                            headers.add(new StompHeader("version", ua.naiksoftware.stomp.client.StompClient$Companion.access$getSUPPORTED_VERSIONS$p(StompClient.Companion)));
                            if (this.$_headers != null) {
                                headers.addAll(this.$_headers);
                            }
                            StompClient.access$getMConnectionProvider$p(this.this$0).send(new StompMessage(StompCommand.INSTANCE.getCONNECT(), (List<? extends StompHeader>)headers, null).compile()).subscribe();
                            break;
                        }
                        case 2: 
                        case 3: {
                            StompClient.access$setConnected$p(this.this$0, false);
                            StompClient.access$setConnecting$p(this.this$0, false);
                        }
                    }
                }
            }
            {
                this.this$0 = stompClient;
                this.$_headers = list;
            }
        });
        this.mMessagesDisposable = this.mConnectionProvider.messages().map((Function)connect.2.INSTANCE).subscribe((Consumer)new Consumer<StompMessage>(this){
            final /* synthetic */ StompClient this$0;

            public final void accept(StompMessage stompMessage) {
                if (Intrinsics.areEqual((Object)stompMessage.getStompCommand(), (Object)StompCommand.INSTANCE.getCONNECTED())) {
                    StompClient.access$setConnected$p(this.this$0, true);
                    StompClient.access$setConnecting$p(this.this$0, false);
                    for (ConnectableFlowable flowable2 : StompClient.access$getMWaitConnectionFlowables$p(this.this$0)) {
                        flowable2.connect();
                    }
                    StompClient.access$getMWaitConnectionFlowables$p(this.this$0).clear();
                }
                StompMessage stompMessage2 = stompMessage;
                Intrinsics.checkExpressionValueIsNotNull((Object)stompMessage2, (String)"stompMessage");
                StompClient.access$callSubscribers(this.this$0, stompMessage2);
            }
            {
                this.this$0 = stompClient;
            }
        });
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void connect$default(StompClient stompClient, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        stompClient.connect(list, bl);
    }

    @JvmOverloads
    public final void connect(@Nullable List<? extends StompHeader> _headers) {
        StompClient.connect$default(this, _headers, false, 2, null);
    }

    @JvmOverloads
    public final void connect() {
        StompClient.connect$default(this, null, false, 3, null);
    }

    @NotNull
    public final Flowable<Void> send(@NotNull String destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        return this.send(new StompMessage(StompCommand.INSTANCE.getSEND(), CollectionsKt.listOf((Object)new StompHeader("destination", destination)), null));
    }

    @NotNull
    public final Flowable<Void> send(@NotNull String destination, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return this.send(new StompMessage(StompCommand.INSTANCE.getSEND(), CollectionsKt.listOf((Object)new StompHeader("destination", destination)), data));
    }

    @NotNull
    public final Flowable<Void> send(@NotNull StompMessage stompMessage) {
        Intrinsics.checkParameterIsNotNull((Object)stompMessage, (String)"stompMessage");
        Flowable<Void> flowable2 = this.mConnectionProvider.send(stompMessage.compile());
        if (!this.isConnected) {
            ConnectableFlowable deferred;
            ConnectableFlowable connectableFlowable = deferred = flowable2.publish();
            Intrinsics.checkExpressionValueIsNotNull((Object)connectableFlowable, (String)"deferred");
            this.mWaitConnectionFlowables.add((ConnectableFlowable<Void>)connectableFlowable);
            return (Flowable)deferred;
        }
        return flowable2;
    }

    private final void callSubscribers(StompMessage stompMessage) {
        String messageDestination = stompMessage.findHeader("destination");
        for (String dest : this.mEmitters.keySet()) {
            if (!Intrinsics.areEqual((Object)dest, (Object)messageDestination)) continue;
            Set<FlowableEmitter<? super StompMessage>> emitters = this.mEmitters.get(dest);
            if (emitters != null) {
                for (FlowableEmitter<? super StompMessage> subscriber : emitters) {
                    subscriber.onNext((Object)stompMessage);
                }
            }
            return;
        }
    }

    @NotNull
    public final Flowable<LifecycleEvent> lifecycle() {
        return this.mConnectionProvider.getLifecycleReceiver();
    }

    public final void disconnect() {
        if (this.mMessagesDisposable != null) {
            Disposable disposable = this.mMessagesDisposable;
            if (disposable != null) {
                disposable.dispose();
            }
        }
        if (this.mLifecycleDisposable != null) {
            Disposable disposable = this.mLifecycleDisposable;
            if (disposable != null) {
                disposable.dispose();
            }
        }
        this.mEmitters.clear();
        this.mWaitConnectionFlowables.clear();
        this.isConnected = false;
        this.mConnectionProvider.disconnect();
    }

    @JvmOverloads
    @NotNull
    public final Flowable<StompMessage> topic(@NotNull String destinationPath, @Nullable List<? extends StompHeader> headerList) {
        Intrinsics.checkParameterIsNotNull((Object)destinationPath, (String)"destinationPath");
        Flowable flowable2 = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(this, destinationPath, headerList){
            final /* synthetic */ StompClient this$0;
            final /* synthetic */ String $destinationPath;
            final /* synthetic */ List $headerList;

            public final void subscribe(@NotNull FlowableEmitter<StompMessage> emitter) {
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                Object object = StompClient.access$getMEmitters$p(this.this$0);
                if (object == null || (object = (Set)((ConcurrentHashMap)object).get(this.$destinationPath)) == null) {
                    Set set;
                    Set $receiver = set = (Set)new LinkedHashSet<E>();
                    StompClient.access$getMEmitters$p(this.this$0).put(this.$destinationPath, $receiver);
                    StompClient.access$subscribePath(this.this$0, this.$destinationPath, this.$headerList).subscribe();
                    object = set;
                }
                Object emitters = object;
                emitters.add(emitter);
            }
            {
                this.this$0 = stompClient;
                this.$destinationPath = string;
                this.$headerList = list;
            }
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).doOnCancel(new Action(this){
            final /* synthetic */ StompClient this$0;

            public final void run() {
                Iterator<E> mapIterator = StompClient.access$getMEmitters$p(this.this$0).keySet().iterator();
                while (mapIterator.hasNext()) {
                    Set set;
                    String destinationUrl = (String)mapIterator.next();
                    Set set2 = set = (Set)StompClient.access$getMEmitters$p(this.this$0).get(destinationUrl);
                    Iterator<E> setIterator = set2 != null ? set2.iterator() : null;
                    if (setIterator == null) continue;
                    while (setIterator.hasNext()) {
                        FlowableEmitter subscriber = (FlowableEmitter)setIterator.next();
                        if (!subscriber.isCancelled()) continue;
                        setIterator.remove();
                        if (set.size() >= 1) continue;
                        mapIterator.remove();
                        String string = destinationUrl;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"destinationUrl");
                        StompClient.access$unsubscribePath(this.this$0, string).subscribe();
                    }
                }
            }
            {
                this.this$0 = stompClient;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable2, (String)"Flowable.create<StompMes\u2026      }\n                }");
        return flowable2;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Flowable topic$default(StompClient stompClient, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        return stompClient.topic(string, list);
    }

    @JvmOverloads
    @NotNull
    public final Flowable<StompMessage> topic(@NotNull String destinationPath) {
        return StompClient.topic$default(this, destinationPath, null, 2, null);
    }

    private final Flowable<Void> subscribePath(String destinationPath, List<? extends StompHeader> headerList) {
        if (destinationPath == null) {
            Flowable flowable2 = Flowable.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)flowable2, (String)"Flowable.empty()");
            return flowable2;
        }
        String topicId = UUID.randomUUID().toString();
        if (this.mTopics == null) {
            this.mTopics = new HashMap();
        }
        HashMap<String, String> hashMap = this.mTopics;
        if (hashMap != null) {
            hashMap.put(destinationPath, topicId);
        }
        ArrayList<StompHeader> headers = new ArrayList<StompHeader>();
        headers.add(new StompHeader("id", topicId));
        headers.add(new StompHeader("destination", destinationPath));
        headers.add(new StompHeader("ack", StompClient.Companion.getDEFAULT_ACK()));
        if (headerList != null) {
            headers.addAll((Collection)headerList);
        }
        return this.send(new StompMessage(StompCommand.INSTANCE.getSUBSCRIBE(), (List<? extends StompHeader>)headers, null));
    }

    private final Flowable<Void> unsubscribePath(String dest) {
        HashMap<String, String> hashMap = this.mTopics;
        String topicId = hashMap != null ? hashMap.get(dest) : null;
        Log.d((String)StompClient.Companion.getTAG(), (String)("Unsubscribe path: " + dest + " id: " + topicId));
        return this.send(new StompMessage(StompCommand.INSTANCE.getUNSUBSCRIBE(), CollectionsKt.listOf((Object)new StompHeader("id", topicId)), null));
    }

    public StompClient(@NotNull ConnectionProvider mConnectionProvider) {
        Intrinsics.checkParameterIsNotNull((Object)mConnectionProvider, (String)"mConnectionProvider");
        this.mConnectionProvider = mConnectionProvider;
        this.mEmitters = new ConcurrentHashMap();
        this.mWaitConnectionFlowables = new CopyOnWriteArrayList();
    }

    static {
        Companion = new Companion(null);
        TAG = StompClient.class.getSimpleName();
        SUPPORTED_VERSIONS = SUPPORTED_VERSIONS;
        DEFAULT_ACK = DEFAULT_ACK;
    }

    @NotNull
    public static final /* synthetic */ ConnectionProvider access$getMConnectionProvider$p(StompClient $this) {
        return $this.mConnectionProvider;
    }

    public static final /* synthetic */ boolean access$isConnected$p(StompClient $this) {
        return $this.isConnected;
    }

    public static final /* synthetic */ void access$setConnected$p(StompClient $this, boolean bl) {
        $this.isConnected = bl;
    }

    public static final /* synthetic */ boolean access$isConnecting$p(StompClient $this) {
        return $this.isConnecting;
    }

    public static final /* synthetic */ void access$setConnecting$p(StompClient $this, boolean bl) {
        $this.isConnecting = bl;
    }

    @NotNull
    public static final /* synthetic */ List access$getMWaitConnectionFlowables$p(StompClient $this) {
        return $this.mWaitConnectionFlowables;
    }

    public static final /* synthetic */ void access$callSubscribers(StompClient $this, @NotNull StompMessage stompMessage) {
        $this.callSubscribers(stompMessage);
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getMEmitters$p(StompClient $this) {
        return $this.mEmitters;
    }

    @NotNull
    public static final /* synthetic */ Flowable access$subscribePath(StompClient $this, @Nullable String destinationPath, @Nullable List headerList) {
        return $this.subscribePath(destinationPath, headerList);
    }

    @NotNull
    public static final /* synthetic */ Flowable access$unsubscribePath(StompClient $this, @NotNull String dest) {
        return $this.unsubscribePath(dest);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u001c\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\f"}, d2={"Lua/naiksoftware/stomp/client/StompClient$Companion;", "", "()V", "DEFAULT_ACK", "", "getDEFAULT_ACK", "()Ljava/lang/String;", "SUPPORTED_VERSIONS", "getSUPPORTED_VERSIONS", "TAG", "kotlin.jvm.PlatformType", "getTAG", "lib_release"})
    public static final class Companion {
        private final String getTAG() {
            return TAG;
        }

        private final String getSUPPORTED_VERSIONS() {
            return SUPPORTED_VERSIONS;
        }

        private final String getDEFAULT_ACK() {
            return DEFAULT_ACK;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ String access$getSUPPORTED_VERSIONS$p(Companion $this) {
            return $this.getSUPPORTED_VERSIONS();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

