/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.utils;

import android.media.ExifInterface;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

final class ExifInterfaceCompat {
    private static final String TAG = ExifInterfaceCompat.class.getSimpleName();
    private static final int EXIF_DEGREE_FALLBACK_VALUE = -1;

    private ExifInterfaceCompat() {
    }

    public static ExifInterface newInstance(String filename) throws IOException {
        if (filename == null) {
            throw new NullPointerException("filename should not be null");
        }
        return new ExifInterface(filename);
    }

    private static Date getExifDateTime(String filepath) {
        ExifInterface exif;
        try {
            exif = ExifInterfaceCompat.newInstance(filepath);
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"cannot read exif", (Throwable)ex);
            return null;
        }
        String date = exif.getAttribute("DateTime");
        if (TextUtils.isEmpty((CharSequence)date)) {
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            return formatter.parse(date);
        }
        catch (ParseException e) {
            Log.d((String)TAG, (String)"failed to parse date taken", (Throwable)e);
            return null;
        }
    }

    public static long getExifDateTimeInMillis(String filepath) {
        Date datetime = ExifInterfaceCompat.getExifDateTime(filepath);
        if (datetime == null) {
            return -1L;
        }
        return datetime.getTime();
    }

    public static int getExifOrientation(String filepath) {
        ExifInterface exif;
        try {
            exif = ExifInterfaceCompat.newInstance(filepath);
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"cannot read exif", (Throwable)ex);
            return -1;
        }
        int orientation = exif.getAttributeInt("Orientation", -1);
        if (orientation == -1) {
            return 0;
        }
        switch (orientation) {
            case 6: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }
}

