/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.loader;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.MergeCursor;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import androidx.loader.content.CursorLoader;
import com.zhihu.matisse.MimeType;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import java.util.HashMap;
import java.util.HashSet;

public class AlbumLoader
extends CursorLoader {
    private static final String COLUMN_BUCKET_ID = "bucket_id";
    private static final String COLUMN_BUCKET_DISPLAY_NAME = "bucket_display_name";
    public static final String COLUMN_URI = "uri";
    public static final String COLUMN_COUNT = "count";
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String[] COLUMNS = new String[]{"_id", "bucket_id", "bucket_display_name", "mime_type", "uri", "count"};
    private static final String[] PROJECTION = new String[]{"_id", "bucket_id", "bucket_display_name", "mime_type", "COUNT(*) AS count"};
    private static final String[] PROJECTION_29 = new String[]{"_id", "bucket_id", "bucket_display_name", "mime_type"};
    private static final String SELECTION = "(media_type=? OR media_type=?) AND _size>0) GROUP BY (bucket_id";
    private static final String SELECTION_29 = "(media_type=? OR media_type=?) AND _size>0";
    private static final String[] SELECTION_ARGS = new String[]{String.valueOf(1), String.valueOf(3)};
    private static final String SELECTION_FOR_SINGLE_MEDIA_TYPE = "media_type=? AND _size>0) GROUP BY (bucket_id";
    private static final String SELECTION_FOR_SINGLE_MEDIA_TYPE_29 = "media_type=? AND _size>0";
    private static final String SELECTION_FOR_SINGLE_MEDIA_GIF_TYPE = "media_type=? AND _size>0 AND mime_type=?) GROUP BY (bucket_id";
    private static final String SELECTION_FOR_SINGLE_MEDIA_GIF_TYPE_29 = "media_type=? AND _size>0 AND mime_type=?";
    private static final String BUCKET_ORDER_BY = "datetaken DESC";

    private static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    private static String[] getSelectionArgsForSingleMediaGifType(int mediaType) {
        return new String[]{String.valueOf(mediaType), "image/gif"};
    }

    private AlbumLoader(Context context, String selection, String[] selectionArgs) {
        super(context, QUERY_URI, AlbumLoader.beforeAndroidTen() ? PROJECTION : PROJECTION_29, selection, selectionArgs, BUCKET_ORDER_BY);
    }

    public static CursorLoader newInstance(Context context) {
        String[] selectionArgs;
        String selection;
        if (SelectionSpec.getInstance().onlyShowGif()) {
            selection = AlbumLoader.beforeAndroidTen() ? SELECTION_FOR_SINGLE_MEDIA_GIF_TYPE : SELECTION_FOR_SINGLE_MEDIA_GIF_TYPE_29;
            selectionArgs = AlbumLoader.getSelectionArgsForSingleMediaGifType(1);
        } else if (SelectionSpec.getInstance().onlyShowImages()) {
            selection = AlbumLoader.beforeAndroidTen() ? SELECTION_FOR_SINGLE_MEDIA_TYPE : SELECTION_FOR_SINGLE_MEDIA_TYPE_29;
            selectionArgs = AlbumLoader.getSelectionArgsForSingleMediaType(1);
        } else if (SelectionSpec.getInstance().onlyShowVideos()) {
            selection = AlbumLoader.beforeAndroidTen() ? SELECTION_FOR_SINGLE_MEDIA_TYPE : SELECTION_FOR_SINGLE_MEDIA_TYPE_29;
            selectionArgs = AlbumLoader.getSelectionArgsForSingleMediaType(3);
        } else {
            selection = AlbumLoader.beforeAndroidTen() ? SELECTION : SELECTION_29;
            selectionArgs = SELECTION_ARGS;
        }
        return new AlbumLoader(context, selection, selectionArgs);
    }

    public Cursor loadInBackground() {
        Cursor albums = super.loadInBackground();
        MatrixCursor allAlbum = new MatrixCursor(COLUMNS);
        if (AlbumLoader.beforeAndroidTen()) {
            int totalCount = 0;
            Uri allAlbumCoverUri = null;
            MatrixCursor otherAlbums = new MatrixCursor(COLUMNS);
            if (albums != null) {
                while (albums.moveToNext()) {
                    long fileId = albums.getLong(albums.getColumnIndex("_id"));
                    long bucketId = albums.getLong(albums.getColumnIndex(COLUMN_BUCKET_ID));
                    String bucketDisplayName = albums.getString(albums.getColumnIndex(COLUMN_BUCKET_DISPLAY_NAME));
                    String mimeType = albums.getString(albums.getColumnIndex("mime_type"));
                    Uri uri = AlbumLoader.getUri(albums);
                    int count = albums.getInt(albums.getColumnIndex(COLUMN_COUNT));
                    otherAlbums.addRow((Object[])new String[]{Long.toString(fileId), Long.toString(bucketId), bucketDisplayName, mimeType, uri.toString(), String.valueOf(count)});
                    totalCount += count;
                }
                if (albums.moveToFirst()) {
                    allAlbumCoverUri = AlbumLoader.getUri(albums);
                }
            }
            allAlbum.addRow((Object[])new String[]{Album.ALBUM_ID_ALL, Album.ALBUM_ID_ALL, "All", null, allAlbumCoverUri == null ? null : allAlbumCoverUri.toString(), String.valueOf(totalCount)});
            return new MergeCursor(new Cursor[]{allAlbum, otherAlbums});
        }
        int totalCount = 0;
        Uri allAlbumCoverUri = null;
        HashMap<Long, Long> countMap = new HashMap<Long, Long>();
        if (albums != null) {
            while (albums.moveToNext()) {
                long bucketId = albums.getLong(albums.getColumnIndex(COLUMN_BUCKET_ID));
                Long count = (Long)countMap.get(bucketId);
                if (count == null) {
                    count = 1L;
                } else {
                    Long l = count;
                    Long bucketDisplayName = count = Long.valueOf(count + 1L);
                }
                countMap.put(bucketId, count);
            }
        }
        MatrixCursor otherAlbums = new MatrixCursor(COLUMNS);
        if (albums != null && albums.moveToFirst()) {
            allAlbumCoverUri = AlbumLoader.getUri(albums);
            HashSet<Long> done = new HashSet<Long>();
            do {
                long bucketId;
                if (done.contains(bucketId = albums.getLong(albums.getColumnIndex(COLUMN_BUCKET_ID)))) continue;
                long fileId = albums.getLong(albums.getColumnIndex("_id"));
                String bucketDisplayName = albums.getString(albums.getColumnIndex(COLUMN_BUCKET_DISPLAY_NAME));
                String mimeType = albums.getString(albums.getColumnIndex("mime_type"));
                Uri uri = AlbumLoader.getUri(albums);
                long count = (Long)countMap.get(bucketId);
                otherAlbums.addRow((Object[])new String[]{Long.toString(fileId), Long.toString(bucketId), bucketDisplayName, mimeType, uri.toString(), String.valueOf(count)});
                done.add(bucketId);
                totalCount = (int)((long)totalCount + count);
            } while (albums.moveToNext());
        }
        allAlbum.addRow((Object[])new String[]{Album.ALBUM_ID_ALL, Album.ALBUM_ID_ALL, "All", null, allAlbumCoverUri == null ? null : allAlbumCoverUri.toString(), String.valueOf(totalCount)});
        return new MergeCursor(new Cursor[]{allAlbum, otherAlbums});
    }

    private static Uri getUri(Cursor cursor) {
        long id = cursor.getLong(cursor.getColumnIndex("_id"));
        String mimeType = cursor.getString(cursor.getColumnIndex("mime_type"));
        Uri contentUri = MimeType.isImage(mimeType) ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : (MimeType.isVideo(mimeType) ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Files.getContentUri((String)"external"));
        Uri uri = ContentUris.withAppendedId((Uri)contentUri, (long)id);
        return uri;
    }

    public void onContentChanged() {
    }

    private static boolean beforeAndroidTen() {
        return Build.VERSION.SDK_INT < 29;
    }
}

