/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui.adapter;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.zhihu.matisse.R;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.entity.SelectionSpec;

public class AlbumsAdapter
extends CursorAdapter {
    private final Drawable mPlaceholder;

    public AlbumsAdapter(Context context, Cursor c, boolean autoRequery) {
        super(context, c, autoRequery);
        TypedArray ta = context.getTheme().obtainStyledAttributes(new int[]{R.attr.album_thumbnail_placeholder});
        this.mPlaceholder = ta.getDrawable(0);
        ta.recycle();
    }

    public AlbumsAdapter(Context context, Cursor c, int flags) {
        super(context, c, flags);
        TypedArray ta = context.getTheme().obtainStyledAttributes(new int[]{R.attr.album_thumbnail_placeholder});
        this.mPlaceholder = ta.getDrawable(0);
        ta.recycle();
    }

    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        return LayoutInflater.from((Context)context).inflate(R.layout.album_list_item, parent, false);
    }

    public void bindView(View view, Context context, Cursor cursor) {
        Album album = Album.valueOf(cursor);
        ((TextView)view.findViewById(R.id.album_name)).setText((CharSequence)album.getDisplayName(context));
        ((TextView)view.findViewById(R.id.album_media_count)).setText((CharSequence)String.valueOf(album.getCount()));
        SelectionSpec.getInstance().imageEngine.loadThumbnail(context, context.getResources().getDimensionPixelSize(R.dimen.media_grid_size), this.mPlaceholder, (ImageView)view.findViewById(R.id.album_cover), album.getCoverUri());
    }
}

