/*
 * Decompiled with CFR 0.152.
 */
package com.doublesymmetry.kotlinaudio.players;

import android.content.Context;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.MediaSessionCompat;
import com.doublesymmetry.kotlinaudio.models.AudioItem;
import com.doublesymmetry.kotlinaudio.models.BufferConfig;
import com.doublesymmetry.kotlinaudio.models.CacheConfig;
import com.doublesymmetry.kotlinaudio.models.DefaultQueuedPlayerOptions;
import com.doublesymmetry.kotlinaudio.models.NotificationMetadata;
import com.doublesymmetry.kotlinaudio.models.PlayerConfig;
import com.doublesymmetry.kotlinaudio.players.BaseAudioPlayer;
import com.doublesymmetry.kotlinaudio.players.MediaSourceExtKt;
import com.google.android.exoplayer2.IllegalSeekPositionException;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;
import com.google.android.exoplayer2.ext.mediasession.TimelineQueueNavigator;
import com.google.android.exoplayer2.source.MediaSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\u0001@B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00102\b\b\u0002\u0010.\u001a\u00020/J\u001e\u0010+\u001a\u00020,2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\b\b\u0002\u0010.\u001a\u00020/J\u001c\u0010+\u001a\u00020,2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u00100\u001a\u00020\fJ\b\u00101\u001a\u00020,H\u0016J\u0018\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020\f2\b\b\u0002\u0010.\u001a\u00020/J\u0018\u00104\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/H\u0016J\u0016\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\fJ\u0006\u00108\u001a\u00020,J\u0006\u00109\u001a\u00020,J\u000e\u0010:\u001a\u00020,2\u0006\u00103\u001a\u00020\fJ\u0014\u0010:\u001a\u00020,2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\f0\u0014J\u0006\u0010<\u001a\u00020,J\u0006\u0010=\u001a\u00020,J\u0016\u0010>\u001a\u00020,2\u0006\u00103\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u0010J\b\u0010?\u001a\u00020,H\u0016R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u0013\u0010$\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u00148F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0016R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/doublesymmetry/kotlinaudio/players/QueuedAudioPlayer;", "Lcom/doublesymmetry/kotlinaudio/players/BaseAudioPlayer;", "context", "Landroid/content/Context;", "playerConfig", "Lcom/doublesymmetry/kotlinaudio/models/PlayerConfig;", "bufferConfig", "Lcom/doublesymmetry/kotlinaudio/models/BufferConfig;", "cacheConfig", "Lcom/doublesymmetry/kotlinaudio/models/CacheConfig;", "(Landroid/content/Context;Lcom/doublesymmetry/kotlinaudio/models/PlayerConfig;Lcom/doublesymmetry/kotlinaudio/models/BufferConfig;Lcom/doublesymmetry/kotlinaudio/models/CacheConfig;)V", "currentIndex", "", "getCurrentIndex", "()I", "currentItem", "Lcom/doublesymmetry/kotlinaudio/models/AudioItem;", "getCurrentItem", "()Lcom/doublesymmetry/kotlinaudio/models/AudioItem;", "items", "", "getItems", "()Ljava/util/List;", "nextIndex", "getNextIndex", "()Ljava/lang/Integer;", "nextItem", "getNextItem", "nextItems", "getNextItems", "playerOptions", "Lcom/doublesymmetry/kotlinaudio/models/DefaultQueuedPlayerOptions;", "getPlayerOptions", "()Lcom/doublesymmetry/kotlinaudio/models/DefaultQueuedPlayerOptions;", "previousIndex", "getPreviousIndex", "previousItem", "getPreviousItem", "previousItems", "getPreviousItems", "queue", "Ljava/util/LinkedList;", "Lcom/google/android/exoplayer2/source/MediaSource;", "add", "", "item", "playWhenReady", "", "atIndex", "destroy", "jumpToItem", "index", "load", "move", "fromIndex", "toIndex", "next", "previous", "remove", "indexes", "removePreviousItems", "removeUpcomingItems", "replaceItem", "stop", "KotlinAudioQueueNavigator", "kotlin-audio_release"})
public final class QueuedAudioPlayer
extends BaseAudioPlayer {
    @NotNull
    private final LinkedList<MediaSource> queue;
    @NotNull
    private final DefaultQueuedPlayerOptions playerOptions;

    public QueuedAudioPlayer(@NotNull Context context, @NotNull PlayerConfig playerConfig, @Nullable BufferConfig bufferConfig, @Nullable CacheConfig cacheConfig) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)playerConfig, (String)"playerConfig");
        super(context, playerConfig, bufferConfig, cacheConfig);
        this.queue = new LinkedList();
        this.playerOptions = new DefaultQueuedPlayerOptions(this.getExoPlayer(), false, 2, null);
        this.getMediaSessionConnector().setQueueNavigator((MediaSessionConnector.QueueNavigator)new KotlinAudioQueueNavigator(this.getMediaSession()));
    }

    public /* synthetic */ QueuedAudioPlayer(Context context, PlayerConfig playerConfig, BufferConfig bufferConfig, CacheConfig cacheConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            playerConfig = new PlayerConfig(false, false, 3, null);
        }
        if ((n & 4) != 0) {
            bufferConfig = null;
        }
        if ((n & 8) != 0) {
            cacheConfig = null;
        }
        this(context, playerConfig, bufferConfig, cacheConfig);
    }

    @Override
    @NotNull
    public DefaultQueuedPlayerOptions getPlayerOptions() {
        return this.playerOptions;
    }

    public final int getCurrentIndex() {
        return this.getExoPlayer().getCurrentWindowIndex();
    }

    @Override
    @Nullable
    public AudioItem getCurrentItem() {
        MediaSource mediaSource = (MediaSource)CollectionsKt.getOrNull((List)this.queue, (int)this.getCurrentIndex());
        return (AudioItem)(mediaSource != null && (mediaSource = mediaSource.getMediaItem()) != null && (mediaSource = mediaSource.playbackProperties) != null ? mediaSource.tag : null);
    }

    @Nullable
    public final Integer getNextIndex() {
        return this.getExoPlayer().getNextWindowIndex() == -1 ? null : Integer.valueOf(this.getExoPlayer().getNextWindowIndex());
    }

    @Nullable
    public final Integer getPreviousIndex() {
        return this.getExoPlayer().getPreviousWindowIndex() == -1 ? null : Integer.valueOf(this.getExoPlayer().getPreviousWindowIndex());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AudioItem> getItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.queue;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaSource mediaSource = (MediaSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MediaItem.PlaybackProperties playbackProperties = it.getMediaItem().playbackProperties;
            Object object = playbackProperties != null ? playbackProperties.tag : null;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.doublesymmetry.kotlinaudio.models.AudioItem");
            collection.add((AudioItem)object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AudioItem> getPreviousItems() {
        List list;
        if (this.queue.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            List list2 = this.queue.subList(0, this.getExoPlayer().getCurrentWindowIndex());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"queue\n                .s\u2026layer.currentWindowIndex)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MediaSource mediaSource = (MediaSource)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                MediaItem.PlaybackProperties playbackProperties = it.getMediaItem().playbackProperties;
                Object object = playbackProperties != null ? playbackProperties.tag : null;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.doublesymmetry.kotlinaudio.models.AudioItem");
                collection.add((AudioItem)object);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AudioItem> getNextItems() {
        List list;
        if (this.queue.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            List list2 = this.queue.subList(this.getExoPlayer().getCurrentWindowIndex(), CollectionsKt.getLastIndex((List)this.queue));
            Intrinsics.checkNotNullExpressionValue(list2, (String)"queue\n                .s\u2026owIndex, queue.lastIndex)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MediaSource mediaSource = (MediaSource)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                MediaItem.PlaybackProperties playbackProperties = it.getMediaItem().playbackProperties;
                Object object = playbackProperties != null ? playbackProperties.tag : null;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.doublesymmetry.kotlinaudio.models.AudioItem");
                collection.add((AudioItem)object);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @Nullable
    public final AudioItem getNextItem() {
        return (AudioItem)CollectionsKt.getOrNull(this.getItems(), (int)(this.getCurrentIndex() + 1));
    }

    @Nullable
    public final AudioItem getPreviousItem() {
        return (AudioItem)CollectionsKt.getOrNull(this.getItems(), (int)(this.getCurrentIndex() - 1));
    }

    @Override
    public void load(@NotNull AudioItem item, boolean playWhenReady) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int currentIndex = this.getExoPlayer().getCurrentWindowIndex();
        MediaSource mediaSource = this.getMediaSourceFromAudioItem(item);
        this.queue.set(currentIndex, mediaSource);
        this.getExoPlayer().removeMediaItem(currentIndex);
        this.getExoPlayer().addMediaSource(currentIndex, mediaSource);
        this.getExoPlayer().setPlayWhenReady(playWhenReady);
        this.getExoPlayer().prepare();
        this.previous();
    }

    public final void add(@NotNull AudioItem item, boolean playWhenReady) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        MediaSource mediaSource = this.getMediaSourceFromAudioItem(item);
        this.queue.add(mediaSource);
        this.getExoPlayer().addMediaSource(mediaSource);
        this.getExoPlayer().setPlayWhenReady(playWhenReady);
        this.getExoPlayer().prepare();
    }

    public static /* synthetic */ void add$default(QueuedAudioPlayer queuedAudioPlayer, AudioItem audioItem, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        queuedAudioPlayer.add(audioItem, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull List<? extends AudioItem> items, boolean playWhenReady) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioItem audioItem = (AudioItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getMediaSourceFromAudioItem((AudioItem)it));
        }
        List mediaSources = (List)destination$iv$iv;
        this.queue.addAll(mediaSources);
        this.getExoPlayer().addMediaSources(mediaSources);
        this.getExoPlayer().setPlayWhenReady(playWhenReady);
        this.getExoPlayer().prepare();
    }

    public static /* synthetic */ void add$default(QueuedAudioPlayer queuedAudioPlayer, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        queuedAudioPlayer.add((List<? extends AudioItem>)list, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull List<? extends AudioItem> items, int atIndex) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AudioItem audioItem = (AudioItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getMediaSourceFromAudioItem((AudioItem)it));
        }
        List mediaSources = (List)destination$iv$iv;
        this.queue.addAll(atIndex, mediaSources);
        this.getExoPlayer().addMediaSources(atIndex, mediaSources);
        this.getExoPlayer().prepare();
    }

    public final void remove(int index) {
        this.queue.remove(index);
        this.getExoPlayer().removeMediaItem(index);
    }

    public final void remove(@NotNull List<Integer> indexes) {
        Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
        Iterable $this$forEach$iv = indexes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.remove(it);
        }
    }

    public final void next() {
        this.getExoPlayer().seekToNext();
    }

    public final void previous() {
        this.getExoPlayer().seekToPrevious();
    }

    public final void move(int fromIndex, int toIndex) {
        this.getExoPlayer().moveMediaItem(fromIndex, toIndex);
    }

    public final void jumpToItem(int index, boolean playWhenReady) {
        this.getExoPlayer().setPlayWhenReady(playWhenReady);
        try {
            this.getExoPlayer().seekTo(index, -1L);
        }
        catch (IllegalSeekPositionException e) {
            throw new Error("This item index " + index + " does not exist. The size of the queue is " + this.queue.size() + " items.");
        }
    }

    public static /* synthetic */ void jumpToItem$default(QueuedAudioPlayer queuedAudioPlayer, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        queuedAudioPlayer.jumpToItem(n, bl);
    }

    public final void replaceItem(int index, @NotNull AudioItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        MediaSource mediaSource = this.getMediaSourceFromAudioItem(item);
        this.queue.set(index, mediaSource);
        if (this.getCurrentIndex() == index && this.getAutomaticallyUpdateNotificationMetadata()) {
            this.getNotificationManager().setNotificationMetadata(new NotificationMetadata(item.getTitle(), item.getArtist(), item.getArtwork()));
        }
    }

    public final void removeUpcomingItems() {
        int lastIndex = CollectionsKt.getLastIndex((List)this.queue);
        if (lastIndex == -1) {
            return;
        }
        this.getExoPlayer().removeMediaItems(this.getCurrentIndex(), lastIndex);
        this.queue.subList(this.getCurrentIndex(), lastIndex).clear();
    }

    public final void removePreviousItems() {
        this.getExoPlayer().removeMediaItems(0, this.getCurrentIndex());
        this.queue.subList(0, this.getCurrentIndex()).clear();
    }

    @Override
    public void stop() {
        super.stop();
        this.queue.clear();
    }

    @Override
    public void destroy() {
        this.queue.clear();
        super.destroy();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/doublesymmetry/kotlinaudio/players/QueuedAudioPlayer$KotlinAudioQueueNavigator;", "Lcom/google/android/exoplayer2/ext/mediasession/TimelineQueueNavigator;", "mediaSession", "Landroid/support/v4/media/session/MediaSessionCompat;", "(Lcom/doublesymmetry/kotlinaudio/players/QueuedAudioPlayer;Landroid/support/v4/media/session/MediaSessionCompat;)V", "getMediaDescription", "Landroid/support/v4/media/MediaDescriptionCompat;", "player", "Lcom/google/android/exoplayer2/Player;", "windowIndex", "", "kotlin-audio_release"})
    private final class KotlinAudioQueueNavigator
    extends TimelineQueueNavigator {
        public KotlinAudioQueueNavigator(MediaSessionCompat mediaSession) {
            Intrinsics.checkNotNullParameter((Object)mediaSession, (String)"mediaSession");
            super(mediaSession);
        }

        @NotNull
        public MediaDescriptionCompat getMediaDescription(@NotNull Player player, int windowIndex) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Object e = QueuedAudioPlayer.this.queue.get(windowIndex);
            Intrinsics.checkNotNullExpressionValue(e, (String)"queue[windowIndex]");
            MediaSource item = (MediaSource)e;
            MediaDescriptionCompat mediaDescriptionCompat = MediaSourceExtKt.getMediaMetadataCompat(item).getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)mediaDescriptionCompat, (String)"item.getMediaMetadataCompat().description");
            return mediaDescriptionCompat;
        }
    }
}

