/*
 * Decompiled with CFR 0.152.
 */
package com.doodle.android.chips.model;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.Serializable;

public class Contact
implements Comparable<Contact>,
Serializable {
    @Nullable
    private final String mFirstName;
    @Nullable
    private final String mLastName;
    @NonNull
    private final String mEmailAddress;
    @Nullable
    private final transient Uri mAvatarUri;
    @NonNull
    private final String mDisplayName;
    @NonNull
    private final String mInitials;

    public Contact(@Nullable String firstName, @Nullable String lastName, @Nullable String displayName, @NonNull String emailAddress, @Nullable Uri avatarUri) {
        this.mFirstName = firstName;
        this.mLastName = lastName;
        this.mAvatarUri = avatarUri;
        this.mEmailAddress = emailAddress;
        this.mDisplayName = !TextUtils.isEmpty((CharSequence)displayName) ? displayName : (TextUtils.isEmpty((CharSequence)this.mFirstName) ? (TextUtils.isEmpty((CharSequence)this.mLastName) ? this.mEmailAddress : this.mLastName) : (TextUtils.isEmpty((CharSequence)this.mLastName) ? this.mFirstName : this.mFirstName + " " + this.mLastName));
        StringBuilder initialsBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)this.mFirstName)) {
            initialsBuilder.append(Character.toUpperCase(this.mFirstName.charAt(0)));
        }
        if (!TextUtils.isEmpty((CharSequence)this.mLastName)) {
            initialsBuilder.append(Character.toUpperCase(this.mLastName.charAt(0)));
        }
        this.mInitials = initialsBuilder.toString();
    }

    @Nullable
    public String getFirstName() {
        return this.mFirstName;
    }

    @Nullable
    public String getLastName() {
        return this.mLastName;
    }

    @NonNull
    public String getEmailAddress() {
        return this.mEmailAddress;
    }

    @Nullable
    public Uri getAvatarUri() {
        return this.mAvatarUri;
    }

    @NonNull
    public String getDisplayName() {
        return this.mDisplayName;
    }

    @NonNull
    public String getInitials() {
        return this.mInitials;
    }

    @Override
    public int compareTo(Contact another) {
        String otherString;
        if (another == null) {
            return 1;
        }
        String myString = this.mDisplayName != null ? this.mDisplayName : (this.mFirstName != null ? this.mFirstName : this.mLastName);
        int diff = this.compare(myString, otherString = another.mDisplayName != null ? another.mDisplayName : (another.mFirstName != null ? another.mFirstName : another.mLastName));
        if (diff != 0) {
            return diff;
        }
        if (another.mFirstName == null && this.mFirstName != null) {
            return 1;
        }
        if (another.mFirstName != null && this.mFirstName == null) {
            return -1;
        }
        if (another.mFirstName != null && this.mFirstName != null && (diff = this.compare(this.mLastName, another.mLastName)) != 0) {
            return diff;
        }
        return this.mEmailAddress.compareTo(another.mEmailAddress);
    }

    private int compare(String myString, String otherString) {
        boolean isMineBlank = TextUtils.isEmpty((CharSequence)myString);
        boolean isOtherBlank = TextUtils.isEmpty((CharSequence)otherString);
        if (isMineBlank && isOtherBlank) {
            return 0;
        }
        if (isMineBlank) {
            return 1;
        }
        if (isOtherBlank) {
            return -1;
        }
        return myString.toLowerCase().compareTo(otherString.toLowerCase());
    }

    public boolean matches(CharSequence searchString) {
        String lowerCaseSearchString = searchString.toString().toLowerCase();
        return this.mFirstName != null && this.mFirstName.toLowerCase().contains(lowerCaseSearchString) || this.mLastName != null && this.mLastName.toLowerCase().contains(lowerCaseSearchString) || this.mEmailAddress.toLowerCase().contains(lowerCaseSearchString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return this.mEmailAddress.equals(contact.mEmailAddress);
    }

    public int hashCode() {
        return this.mEmailAddress.hashCode();
    }

    public String toString() {
        return "Contact{mFirstName='" + this.mFirstName + '\'' + ", mLastName='" + this.mLastName + '\'' + ", mEmailAddress='" + this.mEmailAddress + '\'' + ", mAvatarUri=" + this.mAvatarUri + ", mDisplayName='" + this.mDisplayName + '\'' + ", mInitials='" + this.mInitials + '\'' + '}';
    }
}

