/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import androidx.annotation.NonNull;
import com.eightbitlab.blurview.R;

class Noise {
    private static Paint noisePaint;

    Noise() {
    }

    static void apply(Canvas canvas, Context context, int width, int height) {
        Noise.initPaint(context);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, noisePaint);
    }

    private static void initPaint(Context context) {
        if (noisePaint == null) {
            Bitmap alphaBitmap = Noise.getNoiseBitmap(context);
            noisePaint = new Paint();
            noisePaint.setAntiAlias(true);
            noisePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
            noisePaint.setShader((Shader)new BitmapShader(alphaBitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
        }
    }

    @NonNull
    private static Bitmap getNoiseBitmap(Context context) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.blue_noise);
        Bitmap alphaBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(alphaBitmap);
        Paint paint = new Paint();
        paint.setAlpha(38);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return alphaBitmap;
    }
}

