/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurController;
import eightbitlab.com.blurview.BlurView;
import eightbitlab.com.blurview.BlurViewCanvas;
import eightbitlab.com.blurview.BlurViewFacade;
import eightbitlab.com.blurview.NoOpBlurAlgorithm;
import eightbitlab.com.blurview.RenderEffectBlur;
import eightbitlab.com.blurview.SizeScaler;

final class BlockingBlurController
implements BlurController {
    @ColorInt
    static final int TRANSPARENT = 0;
    private float blurRadius = 16.0f;
    private BlurAlgorithm blurAlgorithm;
    private BlurViewCanvas internalCanvas;
    private Bitmap internalBitmap;
    final BlurView blurView;
    private int overlayColor;
    private final ViewGroup rootView;
    private final int[] rootLocation = new int[2];
    private final int[] blurViewLocation = new int[2];
    private final ViewTreeObserver.OnPreDrawListener drawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            BlockingBlurController.this.updateBlur();
            return true;
        }
    };
    private boolean blurEnabled = true;
    private boolean initialized;
    @Nullable
    private Drawable frameClearDrawable;
    private final Paint paint = new Paint(2);

    BlockingBlurController(@NonNull BlurView blurView, @NonNull ViewGroup rootView, @ColorInt int overlayColor) {
        this.rootView = rootView;
        this.blurView = blurView;
        this.overlayColor = overlayColor;
        this.blurAlgorithm = new NoOpBlurAlgorithm();
        int measuredWidth = blurView.getMeasuredWidth();
        int measuredHeight = blurView.getMeasuredHeight();
        this.init(measuredWidth, measuredHeight);
    }

    void init(int measuredWidth, int measuredHeight) {
        SizeScaler sizeScaler = new SizeScaler(this.blurAlgorithm.scaleFactor());
        if (sizeScaler.isZeroSized(measuredWidth, measuredHeight)) {
            this.blurView.setWillNotDraw(true);
            return;
        }
        this.blurView.setWillNotDraw(false);
        SizeScaler.Size bitmapSize = sizeScaler.scale(measuredWidth, measuredHeight);
        this.internalBitmap = Bitmap.createBitmap((int)bitmapSize.width, (int)bitmapSize.height, (Bitmap.Config)this.blurAlgorithm.getSupportedBitmapConfig());
        this.internalCanvas = new BlurViewCanvas(this.internalBitmap);
        this.initialized = true;
    }

    void updateBlur() {
        if (!this.blurEnabled || !this.initialized) {
            return;
        }
        if (this.frameClearDrawable == null) {
            this.internalBitmap.eraseColor(0);
        } else {
            this.frameClearDrawable.draw((Canvas)this.internalCanvas);
        }
        this.internalCanvas.save();
        this.setupInternalCanvasMatrix();
        this.rootView.draw((Canvas)this.internalCanvas);
        this.internalCanvas.restore();
        this.blurAndSave();
    }

    private void setupInternalCanvasMatrix() {
        this.rootView.getLocationOnScreen(this.rootLocation);
        this.blurView.getLocationOnScreen(this.blurViewLocation);
        int left = this.blurViewLocation[0] - this.rootLocation[0];
        int top = this.blurViewLocation[1] - this.rootLocation[1];
        float scaleFactorH = (float)this.blurView.getHeight() / (float)this.internalBitmap.getHeight();
        float scaleFactorW = (float)this.blurView.getWidth() / (float)this.internalBitmap.getWidth();
        float scaledLeftPosition = (float)(-left) / scaleFactorW;
        float scaledTopPosition = (float)(-top) / scaleFactorH;
        this.internalCanvas.translate(scaledLeftPosition, scaledTopPosition);
        this.internalCanvas.scale(1.0f / scaleFactorW, 1.0f / scaleFactorH);
    }

    @Override
    public boolean draw(Canvas canvas) {
        if (!this.blurEnabled || !this.initialized) {
            return true;
        }
        if (canvas instanceof BlurViewCanvas) {
            return false;
        }
        this.updateBlur();
        if (!(this.blurAlgorithm instanceof RenderEffectBlur)) {
            float scaleFactorH = (float)this.blurView.getHeight() / (float)this.internalBitmap.getHeight();
            float scaleFactorW = (float)this.blurView.getWidth() / (float)this.internalBitmap.getWidth();
            canvas.save();
            canvas.scale(scaleFactorW, scaleFactorH);
            canvas.drawBitmap(this.internalBitmap, 0.0f, 0.0f, this.paint);
            canvas.restore();
        }
        if (this.overlayColor != 0) {
            canvas.drawColor(this.overlayColor);
        }
        return true;
    }

    private void blurAndSave() {
        this.internalBitmap = this.blurAlgorithm.blur(this.internalBitmap, this.blurRadius);
        if (!this.blurAlgorithm.canModifyBitmap()) {
            this.internalCanvas.setBitmap(this.internalBitmap);
        }
    }

    @Override
    public void updateBlurViewSize() {
        int measuredWidth = this.blurView.getMeasuredWidth();
        int measuredHeight = this.blurView.getMeasuredHeight();
        this.init(measuredWidth, measuredHeight);
    }

    @Override
    public void destroy() {
        this.setBlurAutoUpdate(false);
        this.blurAlgorithm.destroy();
        this.initialized = false;
    }

    @Override
    public BlurViewFacade setBlurRadius(float radius) {
        this.blurRadius = radius;
        return this;
    }

    @Override
    public BlurViewFacade setBlurAlgorithm(BlurAlgorithm algorithm) {
        this.blurAlgorithm = algorithm;
        return this;
    }

    @Override
    public BlurViewFacade setFrameClearDrawable(@Nullable Drawable frameClearDrawable) {
        this.frameClearDrawable = frameClearDrawable;
        return this;
    }

    @Override
    public BlurViewFacade setBlurEnabled(boolean enabled) {
        this.blurEnabled = enabled;
        this.setBlurAutoUpdate(enabled);
        this.blurView.invalidate();
        return this;
    }

    @Override
    public BlurViewFacade setBlurAutoUpdate(boolean enabled) {
        this.rootView.getViewTreeObserver().removeOnPreDrawListener(this.drawListener);
        if (enabled) {
            this.rootView.getViewTreeObserver().addOnPreDrawListener(this.drawListener);
        }
        return this;
    }

    @Override
    @Deprecated
    public BlurViewFacade setHasFixedTransformationMatrix(boolean hasFixedTransformationMatrix) {
        return this;
    }

    @Override
    public BlurViewFacade setOverlayColor(int overlayColor) {
        if (this.overlayColor != overlayColor) {
            this.overlayColor = overlayColor;
            this.blurView.invalidate();
        }
        return this;
    }
}

