/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RenderEffect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurView;
import eightbitlab.com.blurview.RenderEffectPrecision;

@RequiresApi(value=31)
public class RenderEffectBlur
implements BlurAlgorithm {
    private final View backgroundView;
    private final RenderEffectPrecision precision;

    public RenderEffectBlur(final BlurView blurView, RenderEffectPrecision precision) {
        this.backgroundView = new View(blurView.getContext());
        this.precision = precision;
        blurView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                blurView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, blurView.getMeasuredHeight());
                blurView.addView(RenderEffectBlur.this.backgroundView, 0, (ViewGroup.LayoutParams)params);
            }
        });
    }

    @Override
    public Bitmap blur(Bitmap bitmap, float blurRadius) {
        RenderEffect blurEffect;
        if (this.backgroundView.getBackground() == null) {
            BitmapDrawable background = new BitmapDrawable(this.backgroundView.getResources(), bitmap);
            this.backgroundView.setBackground((Drawable)background);
        }
        if (this.precision == RenderEffectPrecision.EXACT) {
            blurEffect = RenderEffect.createBlurEffect((float)blurRadius, (float)blurRadius, (Shader.TileMode)Shader.TileMode.MIRROR);
        } else {
            RenderEffect bitmapInput = RenderEffect.createBitmapEffect((Bitmap)bitmap, null, (Rect)new Rect(0, 0, this.backgroundView.getWidth(), this.backgroundView.getBottom()));
            blurEffect = RenderEffect.createBlurEffect((float)blurRadius, (float)blurRadius, (RenderEffect)bitmapInput, (Shader.TileMode)Shader.TileMode.MIRROR);
        }
        this.backgroundView.setRenderEffect(blurEffect);
        this.backgroundView.invalidate();
        return bitmap;
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean canModifyBitmap() {
        return true;
    }

    @Override
    @NonNull
    public Bitmap.Config getSupportedBitmapConfig() {
        return Bitmap.Config.ARGB_8888;
    }

    @Override
    public float scaleFactor() {
        if (this.precision == RenderEffectPrecision.EXACT) {
            return 1.0f;
        }
        return 4.0f;
    }
}

