/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurController;
import eightbitlab.com.blurview.BlurViewFacade;
import eightbitlab.com.blurview.NoOpBlurAlgorithm;
import eightbitlab.com.blurview.SizeScaler;

final class BlockingBlurController
implements BlurController {
    @ColorInt
    static final int TRANSPARENT = 0;
    private float blurRadius = 16.0f;
    private BlurAlgorithm blurAlgorithm;
    private Canvas internalCanvas;
    private Bitmap internalBitmap;
    final View blurView;
    private int overlayColor;
    private final ViewGroup rootView;
    private final int[] rootLocation = new int[2];
    private final int[] blurViewLocation = new int[2];
    private final SizeScaler sizeScaler = new SizeScaler(8.0f);
    private float scaleFactor = 1.0f;
    private final ViewTreeObserver.OnPreDrawListener drawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            BlockingBlurController.this.updateBlur();
            return true;
        }
    };
    private boolean blurEnabled = true;
    private boolean initialized;
    @Nullable
    private Drawable frameClearDrawable;
    private boolean hasFixedTransformationMatrix;
    private final Paint paint = new Paint(2);

    BlockingBlurController(@NonNull View blurView, @NonNull ViewGroup rootView, @ColorInt int overlayColor) {
        this.rootView = rootView;
        this.blurView = blurView;
        this.overlayColor = overlayColor;
        this.blurAlgorithm = new NoOpBlurAlgorithm();
        int measuredWidth = blurView.getMeasuredWidth();
        int measuredHeight = blurView.getMeasuredHeight();
        this.init(measuredWidth, measuredHeight);
    }

    void init(int measuredWidth, int measuredHeight) {
        if (this.sizeScaler.isZeroSized(measuredWidth, measuredHeight)) {
            this.blurView.setWillNotDraw(true);
            return;
        }
        this.blurView.setWillNotDraw(false);
        this.allocateBitmap(measuredWidth, measuredHeight);
        this.internalCanvas = new Canvas(this.internalBitmap);
        this.initialized = true;
        if (this.hasFixedTransformationMatrix) {
            this.setupInternalCanvasMatrix();
        }
    }

    void updateBlur() {
        if (!this.blurEnabled || !this.initialized) {
            return;
        }
        if (this.frameClearDrawable == null) {
            this.internalBitmap.eraseColor(0);
        } else {
            this.frameClearDrawable.draw(this.internalCanvas);
        }
        if (this.hasFixedTransformationMatrix) {
            this.rootView.draw(this.internalCanvas);
        } else {
            this.internalCanvas.save();
            this.setupInternalCanvasMatrix();
            this.rootView.draw(this.internalCanvas);
            this.internalCanvas.restore();
        }
        this.blurAndSave();
    }

    private void allocateBitmap(int measuredWidth, int measuredHeight) {
        SizeScaler.Size bitmapSize = this.sizeScaler.scale(measuredWidth, measuredHeight);
        this.scaleFactor = bitmapSize.scaleFactor;
        this.internalBitmap = Bitmap.createBitmap((int)bitmapSize.width, (int)bitmapSize.height, (Bitmap.Config)this.blurAlgorithm.getSupportedBitmapConfig());
    }

    private void setupInternalCanvasMatrix() {
        this.rootView.getLocationOnScreen(this.rootLocation);
        this.blurView.getLocationOnScreen(this.blurViewLocation);
        int left = this.blurViewLocation[0] - this.rootLocation[0];
        int top = this.blurViewLocation[1] - this.rootLocation[1];
        float scaledLeftPosition = (float)(-left) / this.scaleFactor;
        float scaledTopPosition = (float)(-top) / this.scaleFactor;
        this.internalCanvas.translate(scaledLeftPosition, scaledTopPosition);
        this.internalCanvas.scale(1.0f / this.scaleFactor, 1.0f / this.scaleFactor);
    }

    @Override
    public boolean draw(Canvas canvas) {
        if (!this.blurEnabled || !this.initialized) {
            return true;
        }
        if (canvas == this.internalCanvas) {
            return false;
        }
        this.updateBlur();
        canvas.save();
        canvas.scale(this.scaleFactor, this.scaleFactor);
        canvas.drawBitmap(this.internalBitmap, 0.0f, 0.0f, this.paint);
        canvas.restore();
        if (this.overlayColor != 0) {
            canvas.drawColor(this.overlayColor);
        }
        return true;
    }

    private void blurAndSave() {
        this.internalBitmap = this.blurAlgorithm.blur(this.internalBitmap, this.blurRadius);
        if (!this.blurAlgorithm.canModifyBitmap()) {
            this.internalCanvas.setBitmap(this.internalBitmap);
        }
    }

    @Override
    public void updateBlurViewSize() {
        int measuredWidth = this.blurView.getMeasuredWidth();
        int measuredHeight = this.blurView.getMeasuredHeight();
        this.init(measuredWidth, measuredHeight);
    }

    @Override
    public void destroy() {
        this.setBlurAutoUpdate(false);
        this.blurAlgorithm.destroy();
        this.initialized = false;
    }

    @Override
    public BlurViewFacade setBlurRadius(float radius) {
        this.blurRadius = radius;
        return this;
    }

    @Override
    public BlurViewFacade setBlurAlgorithm(BlurAlgorithm algorithm) {
        this.blurAlgorithm = algorithm;
        return this;
    }

    @Override
    public BlurViewFacade setFrameClearDrawable(@Nullable Drawable frameClearDrawable) {
        this.frameClearDrawable = frameClearDrawable;
        return this;
    }

    @Override
    public BlurViewFacade setBlurEnabled(boolean enabled) {
        this.blurEnabled = enabled;
        this.setBlurAutoUpdate(enabled);
        this.blurView.invalidate();
        return this;
    }

    @Override
    public BlurViewFacade setBlurAutoUpdate(boolean enabled) {
        this.blurView.getViewTreeObserver().removeOnPreDrawListener(this.drawListener);
        if (enabled) {
            this.blurView.getViewTreeObserver().addOnPreDrawListener(this.drawListener);
        }
        return this;
    }

    @Override
    public BlurViewFacade setHasFixedTransformationMatrix(boolean hasFixedTransformationMatrix) {
        this.hasFixedTransformationMatrix = hasFixedTransformationMatrix;
        return this;
    }

    @Override
    public BlurViewFacade setOverlayColor(int overlayColor) {
        if (this.overlayColor != overlayColor) {
            this.overlayColor = overlayColor;
            this.blurView.invalidate();
        }
        return this;
    }
}

