/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import eightbitlab.com.blurview.BlurAlgorithm;

@Deprecated
public class RenderScriptBlur
implements BlurAlgorithm {
    private final Paint paint = new Paint(2);
    private final RenderScript renderScript;
    private final ScriptIntrinsicBlur blurScript;
    private Allocation outAllocation;
    private int lastBitmapWidth = -1;
    private int lastBitmapHeight = -1;

    @RequiresApi(api=17)
    public RenderScriptBlur(@NonNull Context context) {
        this.renderScript = RenderScript.create((Context)context);
        this.blurScript = ScriptIntrinsicBlur.create((RenderScript)this.renderScript, (Element)Element.U8_4((RenderScript)this.renderScript));
    }

    private boolean canReuseAllocation(@NonNull Bitmap bitmap) {
        return bitmap.getHeight() == this.lastBitmapHeight && bitmap.getWidth() == this.lastBitmapWidth;
    }

    @Override
    @RequiresApi(api=17)
    public Bitmap blur(@NonNull Bitmap bitmap, float blurRadius) {
        Allocation inAllocation = Allocation.createFromBitmap((RenderScript)this.renderScript, (Bitmap)bitmap);
        if (!this.canReuseAllocation(bitmap)) {
            if (this.outAllocation != null) {
                this.outAllocation.destroy();
            }
            this.outAllocation = Allocation.createTyped((RenderScript)this.renderScript, (Type)inAllocation.getType());
            this.lastBitmapWidth = bitmap.getWidth();
            this.lastBitmapHeight = bitmap.getHeight();
        }
        this.blurScript.setRadius(blurRadius);
        this.blurScript.setInput(inAllocation);
        this.blurScript.forEach(this.outAllocation);
        this.outAllocation.copyTo(bitmap);
        inAllocation.destroy();
        return bitmap;
    }

    @Override
    public final void destroy() {
        this.blurScript.destroy();
        this.renderScript.destroy();
        if (this.outAllocation != null) {
            this.outAllocation.destroy();
        }
    }

    @Override
    public boolean canModifyBitmap() {
        return true;
    }

    @Override
    @NonNull
    public Bitmap.Config getSupportedBitmapConfig() {
        return Bitmap.Config.ARGB_8888;
    }

    @Override
    public float scaleFactor() {
        return 6.0f;
    }

    @Override
    public void render(@NonNull Canvas canvas, @NonNull Bitmap bitmap) {
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.paint);
    }
}

